/*
 * Decompiled with CFR 0.152.
 */
package com.noveogroup.android.log;

import com.noveogroup.android.log.Logger;
import com.noveogroup.android.log.LoggerManager;
import com.noveogroup.android.log.Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;

public abstract class Pattern {
    private final int count;
    private final int length;

    private Pattern(int count, int length) {
        this.count = count;
        this.length = length;
    }

    public final String apply(StackTraceElement caller, String loggerName, Logger.Level level) {
        String string = this.doApply(caller, loggerName, level);
        return Utils.shorten(string, this.count, this.length);
    }

    protected abstract String doApply(StackTraceElement var1, String var2, Logger.Level var3);

    protected boolean isCallerNeeded() {
        return false;
    }

    public static Pattern compile(String pattern) {
        try {
            return pattern == null ? null : new Compiler().compile(pattern);
        }
        catch (Exception e) {
            LoggerManager.getLogger("ROOT").e(e, "cannot parse pattern: '%s'", pattern);
            return new PlainPattern(0, 0, pattern);
        }
    }

    public static class Compiler {
        private String patternString;
        private int position;
        private List<ConcatenatePattern> queue;
        private final java.util.regex.Pattern PERCENT_PATTERN = java.util.regex.Pattern.compile("%%");
        private final java.util.regex.Pattern NEWLINE_PATTERN = java.util.regex.Pattern.compile("%n");
        private final java.util.regex.Pattern LEVEL_PATTERN = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?level");
        private final java.util.regex.Pattern LOGGER_PATTERN = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?logger(\\{([+-]?\\d+)?(\\.([+-]?\\d+))?\\})?");
        private final java.util.regex.Pattern CALLER_PATTERN = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?caller(\\{([+-]?\\d+)?(\\.([+-]?\\d+))?\\})?");
        private final java.util.regex.Pattern SOURCE_PATTERN = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?source");
        private final java.util.regex.Pattern DATE_PATTERN = java.util.regex.Pattern.compile("%date(\\{(.*?)\\})?");
        private final java.util.regex.Pattern CONCATENATE_PATTERN = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?\\(");
        private final java.util.regex.Pattern DATE_PATTERN_SHORT = java.util.regex.Pattern.compile("%d(\\{(.*?)\\})?");
        private final java.util.regex.Pattern LEVEL_PATTERN_SHORT = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?p");
        private final java.util.regex.Pattern LOGGER_PATTERN_SHORT = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?c(\\{([+-]?\\d+)?(\\.([+-]?\\d+))?\\})?");
        private final java.util.regex.Pattern CALLER_PATTERN_SHORT = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?C(\\{([+-]?\\d+)?(\\.([+-]?\\d+))?\\})?");
        private final java.util.regex.Pattern SOURCE_PATTERN_SHORT = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?s");
        private final java.util.regex.Pattern THREAD_NAME_PATTERN = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?thread");
        private final java.util.regex.Pattern THREAD_NAME_PATTERN_SHORT = java.util.regex.Pattern.compile("%([+-]?\\d+)?(\\.([+-]?\\d+))?t");

        public Pattern compile(String string) {
            if (string == null) {
                return null;
            }
            this.position = 0;
            this.patternString = string;
            this.queue = new ArrayList<ConcatenatePattern>();
            this.queue.add(new ConcatenatePattern(0, 0, new ArrayList<Pattern>()));
            while (string.length() > this.position) {
                int index = string.indexOf("%", this.position);
                int bracketIndex = string.indexOf(")", this.position);
                if (this.queue.size() > 1 && bracketIndex < index) {
                    this.queue.get(this.queue.size() - 1).addPattern(new PlainPattern(0, 0, string.substring(this.position, bracketIndex)));
                    this.queue.get(this.queue.size() - 2).addPattern(this.queue.remove(this.queue.size() - 1));
                    this.position = bracketIndex + 1;
                }
                if (index == -1) {
                    this.queue.get(this.queue.size() - 1).addPattern(new PlainPattern(0, 0, string.substring(this.position)));
                    break;
                }
                this.queue.get(this.queue.size() - 1).addPattern(new PlainPattern(0, 0, string.substring(this.position, index)));
                this.position = index;
                this.parse();
            }
            return this.queue.get(0);
        }

        private void parse() {
            Matcher matcher = this.findPattern(this.PERCENT_PATTERN);
            if (matcher != null) {
                this.queue.get(this.queue.size() - 1).addPattern(new PlainPattern(0, 0, "%"));
                this.position = matcher.end();
                return;
            }
            matcher = this.findPattern(this.NEWLINE_PATTERN);
            if (matcher != null) {
                this.queue.get(this.queue.size() - 1).addPattern(new PlainPattern(0, 0, "\n"));
                this.position = matcher.end();
                return;
            }
            matcher = this.findPattern(this.LEVEL_PATTERN);
            if (matcher != null || (matcher = this.findPattern(this.LEVEL_PATTERN_SHORT)) != null) {
                int count = Integer.parseInt(matcher.group(1) == null ? "0" : matcher.group(1));
                int length = Integer.parseInt(matcher.group(3) == null ? "0" : matcher.group(3));
                this.queue.get(this.queue.size() - 1).addPattern(new LevelPattern(count, length));
                this.position = matcher.end();
                return;
            }
            matcher = this.findPattern(this.CALLER_PATTERN);
            if (matcher != null || (matcher = this.findPattern(this.CALLER_PATTERN_SHORT)) != null) {
                int count = Integer.parseInt(matcher.group(1) == null ? "0" : matcher.group(1));
                int length = Integer.parseInt(matcher.group(3) == null ? "0" : matcher.group(3));
                int countCaller = Integer.parseInt(matcher.group(5) == null ? "0" : matcher.group(5));
                int lengthCaller = Integer.parseInt(matcher.group(7) == null ? "0" : matcher.group(7));
                this.queue.get(this.queue.size() - 1).addPattern(new CallerPattern(count, length, countCaller, lengthCaller));
                this.position = matcher.end();
                return;
            }
            matcher = this.findPattern(this.SOURCE_PATTERN);
            if (matcher != null || (matcher = this.findPattern(this.SOURCE_PATTERN_SHORT)) != null) {
                int count = Integer.parseInt(matcher.group(1) == null ? "0" : matcher.group(1));
                int length = Integer.parseInt(matcher.group(3) == null ? "0" : matcher.group(3));
                this.queue.get(this.queue.size() - 1).addPattern(new SourcePattern(count, length));
                this.position = matcher.end();
                return;
            }
            matcher = this.findPattern(this.LOGGER_PATTERN);
            if (matcher != null || (matcher = this.findPattern(this.LOGGER_PATTERN_SHORT)) != null) {
                int count = Integer.parseInt(matcher.group(1) == null ? "0" : matcher.group(1));
                int length = Integer.parseInt(matcher.group(3) == null ? "0" : matcher.group(3));
                int countLogger = Integer.parseInt(matcher.group(5) == null ? "0" : matcher.group(5));
                int lengthLogger = Integer.parseInt(matcher.group(7) == null ? "0" : matcher.group(7));
                this.queue.get(this.queue.size() - 1).addPattern(new LoggerPattern(count, length, countLogger, lengthLogger));
                this.position = matcher.end();
                return;
            }
            matcher = this.findPattern(this.DATE_PATTERN);
            if (matcher != null || (matcher = this.findPattern(this.DATE_PATTERN_SHORT)) != null) {
                String dateFormat = matcher.group(2);
                this.queue.get(this.queue.size() - 1).addPattern(new DatePattern(0, 0, dateFormat));
                this.position = matcher.end();
                return;
            }
            matcher = this.findPattern(this.THREAD_NAME_PATTERN);
            if (matcher != null || (matcher = this.findPattern(this.THREAD_NAME_PATTERN_SHORT)) != null) {
                int count = Integer.parseInt(matcher.group(1) == null ? "0" : matcher.group(1));
                int length = Integer.parseInt(matcher.group(3) == null ? "0" : matcher.group(3));
                this.queue.get(this.queue.size() - 1).addPattern(new ThreadNamePattern(count, length));
                this.position = matcher.end();
                return;
            }
            matcher = this.findPattern(this.CONCATENATE_PATTERN);
            if (matcher != null) {
                int count = Integer.parseInt(matcher.group(1) == null ? "0" : matcher.group(1));
                int length = Integer.parseInt(matcher.group(3) == null ? "0" : matcher.group(3));
                this.queue.add(new ConcatenatePattern(count, length, new ArrayList<Pattern>()));
                this.position = matcher.end();
                return;
            }
            throw new IllegalArgumentException();
        }

        private Matcher findPattern(java.util.regex.Pattern pattern) {
            Matcher matcher = pattern.matcher(this.patternString);
            return matcher.find(this.position) && matcher.start() == this.position ? matcher : null;
        }
    }

    public static class ThreadNamePattern
    extends Pattern {
        public ThreadNamePattern(int count, int length) {
            super(count, length);
        }

        @Override
        protected String doApply(StackTraceElement caller, String loggerName, Logger.Level level) {
            return Thread.currentThread().getName();
        }
    }

    public static class ConcatenatePattern
    extends Pattern {
        private final List<Pattern> patternList;

        public ConcatenatePattern(int count, int length, List<Pattern> patternList) {
            super(count, length);
            this.patternList = new ArrayList<Pattern>(patternList);
        }

        public void addPattern(Pattern pattern) {
            this.patternList.add(pattern);
        }

        @Override
        protected String doApply(StackTraceElement caller, String loggerName, Logger.Level level) {
            StringBuilder builder = new StringBuilder();
            for (Pattern pattern : this.patternList) {
                builder.append(pattern.apply(caller, loggerName, level));
            }
            return builder.toString();
        }

        @Override
        protected boolean isCallerNeeded() {
            for (Pattern pattern : this.patternList) {
                if (!pattern.isCallerNeeded()) continue;
                return true;
            }
            return false;
        }
    }

    public static class SourcePattern
    extends Pattern {
        public SourcePattern(int count, int length) {
            super(count, length);
        }

        @Override
        protected String doApply(StackTraceElement caller, String loggerName, Logger.Level level) {
            if (caller == null) {
                throw new IllegalArgumentException("Caller not found");
            }
            StringBuilder builder = new StringBuilder();
            if (caller.isNativeMethod()) {
                builder.append("(native)");
            } else if (caller.getFileName() == null) {
                builder.append("(unknown)");
            } else if (caller.getLineNumber() >= 0) {
                builder.append(String.format("(%s:%d)", caller.getFileName(), caller.getLineNumber()));
            } else {
                builder.append(String.format("(%s)", caller.getFileName()));
            }
            return builder.toString();
        }

        @Override
        protected boolean isCallerNeeded() {
            return true;
        }
    }

    public static class CallerPattern
    extends Pattern {
        private int callerCount;
        private int callerLength;

        public CallerPattern(int count, int length, int callerCount, int callerLength) {
            super(count, length);
            this.callerCount = callerCount;
            this.callerLength = callerLength;
        }

        @Override
        protected String doApply(StackTraceElement caller, String loggerName, Logger.Level level) {
            if (caller == null) {
                throw new IllegalArgumentException("Caller not found");
            }
            String callerString = caller.getLineNumber() < 0 ? String.format("%s#%s", caller.getClassName(), caller.getMethodName()) : String.format("%s#%s:%d", caller.getClassName(), caller.getMethodName(), caller.getLineNumber());
            return Utils.shortenClassName(callerString, this.callerCount, this.callerLength);
        }

        @Override
        protected boolean isCallerNeeded() {
            return true;
        }
    }

    public static class LoggerPattern
    extends Pattern {
        private int loggerCount;
        private int loggerLength;

        public LoggerPattern(int count, int length, int loggerCount, int loggerLength) {
            super(count, length);
            this.loggerCount = loggerCount;
            this.loggerLength = loggerLength;
        }

        @Override
        protected String doApply(StackTraceElement caller, String loggerName, Logger.Level level) {
            return Utils.shortenClassName(loggerName, this.loggerCount, this.loggerLength);
        }
    }

    public static class LevelPattern
    extends Pattern {
        public LevelPattern(int count, int length) {
            super(count, length);
        }

        @Override
        protected String doApply(StackTraceElement caller, String loggerName, Logger.Level level) {
            return level.toString();
        }
    }

    public static class DatePattern
    extends Pattern {
        private final SimpleDateFormat dateFormat;

        public DatePattern(int count, int length, String dateFormat) {
            super(count, length);
            this.dateFormat = dateFormat != null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }

        @Override
        protected String doApply(StackTraceElement caller, String loggerName, Logger.Level level) {
            return this.dateFormat.format(new Date());
        }
    }

    public static class PlainPattern
    extends Pattern {
        private final String string;

        public PlainPattern(int count, int length, String string) {
            super(count, length);
            this.string = string;
        }

        @Override
        protected String doApply(StackTraceElement caller, String loggerName, Logger.Level level) {
            return this.string;
        }
    }
}

