/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.content.Context;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.rilixtech.Country;
import com.rilixtech.CountryCodeDialog;
import com.rilixtech.CountryCodePicker;
import com.rilixtech.CountryUtils;
import com.rilixtech.R;
import java.util.List;

class CountryCodeAdapter
extends RecyclerView.Adapter<CountryCodeViewHolder> {
    private final List<Country> mCountries;
    private final CountryCodePicker mCountryCodePicker;
    private final CountryCodeDialog.ItemRecyclerViewClickListener mListener;

    CountryCodeAdapter(List<Country> countries, CountryCodePicker codePicker, CountryCodeDialog.ItemRecyclerViewClickListener listener) {
        this.mCountries = countries;
        this.mCountryCodePicker = codePicker;
        this.mListener = listener;
    }

    public CountryCodeViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        LayoutInflater inflater = LayoutInflater.from((Context)viewGroup.getContext());
        View view = inflater.inflate(R.layout.layout_recycler_country_tile, viewGroup, false);
        return new CountryCodeViewHolder(view);
    }

    public void onBindViewHolder(CountryCodeViewHolder viewHolder, int i) {
        int position = viewHolder.getAdapterPosition();
        Country country = this.mCountries.get(position);
        viewHolder.setCountry(this.mCountryCodePicker, country);
        viewHolder.rlyMain.setOnClickListener((View.OnClickListener)(country != null ? this.mListener : null));
    }

    public int getItemCount() {
        return this.mCountries.size();
    }

    class CountryCodeViewHolder
    extends RecyclerView.ViewHolder {
        RelativeLayout rlyMain;
        AppCompatTextView tvName;
        AppCompatTextView tvCode;
        AppCompatImageView imvFlag;
        LinearLayout llyFlagHolder;
        View viewDivider;

        CountryCodeViewHolder(View itemView) {
            super(itemView);
            this.rlyMain = (RelativeLayout)itemView;
            this.tvName = (AppCompatTextView)this.rlyMain.findViewById(R.id.country_name_tv);
            this.tvCode = (AppCompatTextView)this.rlyMain.findViewById(R.id.code_tv);
            this.imvFlag = (AppCompatImageView)this.rlyMain.findViewById(R.id.flag_imv);
            this.llyFlagHolder = (LinearLayout)this.rlyMain.findViewById(R.id.flag_holder_lly);
            this.viewDivider = this.rlyMain.findViewById(R.id.preference_divider_view);
        }

        private void setCountry(CountryCodePicker picker, Country country) {
            if (country == null) {
                this.viewDivider.setVisibility(0);
                this.tvName.setVisibility(8);
                this.tvCode.setVisibility(8);
                this.llyFlagHolder.setVisibility(8);
            } else {
                this.viewDivider.setVisibility(8);
                this.tvName.setVisibility(0);
                this.tvCode.setVisibility(0);
                this.llyFlagHolder.setVisibility(0);
                Context ctx = this.tvName.getContext();
                String name = country.getName();
                String iso = country.getIso().toUpperCase();
                String countryNameAndCode = ctx.getString(R.string.country_name_and_code, new Object[]{name, iso});
                this.tvName.setText((CharSequence)countryNameAndCode);
                if (picker.isHidePhoneCode()) {
                    this.tvCode.setVisibility(8);
                } else {
                    this.tvCode.setText((CharSequence)ctx.getString(R.string.phone_code, new Object[]{country.getPhoneCode()}));
                }
                Typeface typeface = picker.getTypeFace();
                if (typeface != null) {
                    this.tvCode.setTypeface(typeface);
                    this.tvName.setTypeface(typeface);
                }
                this.imvFlag.setImageResource(CountryUtils.getFlagDrawableResId(country));
                int color2 = picker.getDialogTextColor();
                if (color2 != picker.getDefaultContentColor()) {
                    this.tvCode.setTextColor(color2);
                    this.tvName.setTextColor(color2);
                }
            }
        }
    }
}

