/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.rilixtech.Country;
import com.rilixtech.CountryCodeDialog;
import com.rilixtech.CountryUtils;
import com.rilixtech.R;
import java.util.ArrayList;
import java.util.List;

public class CountryCodePicker
extends RelativeLayout {
    private static String TAG = CountryCodePicker.class.getSimpleName();
    private static final String BUNDLE_SELECTED_CODE = "selectedCode";
    private static final int LIB_DEFAULT_COUNTRY_CODE = 62;
    private int mDefaultCountryCode;
    private String mDefaultCountryNameCode;
    private View mViewHolder;
    private LayoutInflater mInflater;
    private AppCompatTextView mTvSelectedCountry;
    private AppCompatEditText mEdtRegisteredCarrierNumber;
    private RelativeLayout mRlyHolder;
    private AppCompatImageView mImvArrow;
    private AppCompatImageView mImvFlag;
    private LinearLayout mLlyFlagHolder;
    private Country mSelectedCountry;
    private Country mDefaultCountry;
    private RelativeLayout mRlyClickConsumer;
    private CountryCodePicker mCcpCodePicker;
    private boolean mHideNameCode = false;
    private boolean mShowFlag = true;
    private boolean mShowFullName = false;
    private boolean mUseFullName = false;
    private boolean mSelectionDialogShowSearch = true;
    private int mContentColor;
    private List<Country> mPreferredCountries;
    private String mCountryPreference;
    private List<Country> mCustomMasterCountriesList;
    private String mCustomMasterCountries;
    private boolean mKeyboardAutoPopOnSearch = true;
    private boolean mIsClickable = true;
    private CountryCodeDialog countryCodeDialog;
    private Typeface mTypeFace;
    View.OnClickListener countryCodeHolderClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (CountryCodePicker.this.isClickable()) {
                if (CountryCodePicker.this.countryCodeDialog == null) {
                    CountryCodePicker.this.countryCodeDialog = new CountryCodeDialog(CountryCodePicker.this.mCcpCodePicker);
                    CountryCodePicker.this.countryCodeDialog.show();
                } else {
                    CountryCodePicker.this.countryCodeDialog.reShow();
                }
            }
        }
    };
    private OnCountryChangeListener onCountryChangeListener;

    public CountryCodePicker(Context context) {
        super(context);
        this.init(null);
    }

    public CountryCodePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public CountryCodePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.mInflater = LayoutInflater.from((Context)this.getContext());
        this.mViewHolder = this.mInflater.inflate(R.layout.layout_code_picker, (ViewGroup)this, true);
        this.mTvSelectedCountry = (AppCompatTextView)this.mViewHolder.findViewById(R.id.selected_country_tv);
        this.mRlyHolder = (RelativeLayout)this.mViewHolder.findViewById(R.id.country_code_holder_rly);
        this.mImvArrow = (AppCompatImageView)this.mViewHolder.findViewById(R.id.arrow_imv);
        this.mImvFlag = (AppCompatImageView)this.mViewHolder.findViewById(R.id.flag_imv);
        this.mLlyFlagHolder = (LinearLayout)this.mViewHolder.findViewById(R.id.flag_holder_lly);
        this.mRlyClickConsumer = (RelativeLayout)this.mViewHolder.findViewById(R.id.click_consumer_rly);
        this.mCcpCodePicker = this;
        this.applyCustomProperty(attrs);
        this.mRlyClickConsumer.setOnClickListener(this.countryCodeHolderClickListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCustomProperty(AttributeSet attrs) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.CountryCodePicker, 0, 0);
        try {
            int textSize;
            String fontPath;
            this.mHideNameCode = a.getBoolean(R.styleable.CountryCodePicker_ccp_hideNameCode, false);
            this.mShowFullName = a.getBoolean(R.styleable.CountryCodePicker_ccp_showFullName, false);
            this.setKeyboardAutoPopOnSearch(a.getBoolean(R.styleable.CountryCodePicker_ccp_keyboardAutoPopOnSearch, true));
            this.mCustomMasterCountries = a.getString(R.styleable.CountryCodePicker_ccp_customMasterCountries);
            this.refreshCustomMasterList();
            this.mCountryPreference = a.getString(R.styleable.CountryCodePicker_ccp_countryPreference);
            this.refreshPreferredCountries();
            this.mDefaultCountryNameCode = a.getString(R.styleable.CountryCodePicker_ccp_defaultNameCode);
            boolean setUsingNameCode = false;
            if (this.mDefaultCountryNameCode != null && this.mDefaultCountryNameCode.length() != 0 && CountryUtils.getCountryByNameCodeFromAllCountries(this.getContext(), this.mDefaultCountryNameCode) != null) {
                setUsingNameCode = true;
                this.setDefaultCountry(CountryUtils.getCountryByNameCodeFromAllCountries(this.getContext(), this.mDefaultCountryNameCode));
                this.setSelectedCountry(this.mDefaultCountry);
            }
            if (!setUsingNameCode) {
                int defaultCountryCode = a.getInteger(R.styleable.CountryCodePicker_ccp_defaultCode, -1);
                if (CountryUtils.getCountryByCode(this.getContext(), this.mPreferredCountries, defaultCountryCode) == null) {
                    defaultCountryCode = 62;
                }
                this.setDefaultCountryUsingPhoneCode(defaultCountryCode);
                this.setSelectedCountry(this.mDefaultCountry);
            }
            this.showFlag(a.getBoolean(R.styleable.CountryCodePicker_ccp_showFlag, true));
            int contentColor = this.isInEditMode() ? a.getColor(R.styleable.CountryCodePicker_ccp_contentColor, 0) : a.getColor(R.styleable.CountryCodePicker_ccp_contentColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.defaultContentColor));
            if (contentColor != 0) {
                this.setContentColor(contentColor);
            }
            if ((fontPath = a.getString(R.styleable.CountryCodePicker_ccp_textFont)) != null && fontPath.length() != 0) {
                this.setTypeFace(fontPath);
            }
            if ((textSize = a.getDimensionPixelSize(R.styleable.CountryCodePicker_ccp_textSize, 0)) > 0) {
                this.mTvSelectedCountry.setTextSize(0, (float)textSize);
                this.setFlagSize(textSize);
                this.setArrowSize(textSize);
            } else {
                DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
                int defaultSize = Math.round(18.0f * (dm.xdpi / 160.0f));
                this.setTextSize(defaultSize);
            }
            int arrowSize = a.getDimensionPixelSize(R.styleable.CountryCodePicker_ccp_arrowSize, 0);
            if (arrowSize > 0) {
                this.setArrowSize(arrowSize);
            }
            this.mSelectionDialogShowSearch = a.getBoolean(R.styleable.CountryCodePicker_ccp_selectionDialogShowSearch, true);
            this.setClickable(a.getBoolean(R.styleable.CountryCodePicker_ccp_Clickable, true));
        }
        catch (Exception e) {
            this.mTvSelectedCountry.setText((CharSequence)e.getMessage());
        }
        finally {
            a.recycle();
        }
    }

    private Country getDefaultCountry() {
        return this.mDefaultCountry;
    }

    private void setDefaultCountry(Country defaultCountry) {
        this.mDefaultCountry = defaultCountry;
    }

    private TextView getTvSelectedCountry() {
        return this.mTvSelectedCountry;
    }

    private void setTvSelectedCountry(AppCompatTextView tvSelectedCountry) {
        this.mTvSelectedCountry = tvSelectedCountry;
    }

    private Country getSelectedCountry() {
        return this.mSelectedCountry;
    }

    void setSelectedCountry(Country selectedCountry) {
        this.mSelectedCountry = selectedCountry;
        if (selectedCountry == null) {
            selectedCountry = CountryUtils.getCountryByCode(this.getContext(), this.mPreferredCountries, this.mDefaultCountryCode);
        }
        if (!this.mHideNameCode) {
            if (this.mShowFullName) {
                this.mTvSelectedCountry.setText((CharSequence)(selectedCountry.getName().toUpperCase() + "  +" + selectedCountry.getPhoneCode()));
            } else {
                this.mTvSelectedCountry.setText((CharSequence)("(" + selectedCountry.getNameCode().toUpperCase() + ")  +" + selectedCountry.getPhoneCode()));
            }
        } else {
            this.mTvSelectedCountry.setText((CharSequence)("+" + selectedCountry.getPhoneCode()));
        }
        if (this.onCountryChangeListener != null) {
            this.onCountryChangeListener.onCountrySelected();
        }
        this.mImvFlag.setImageResource(selectedCountry.getFlagDrawableResId());
    }

    private View getHolderView() {
        return this.mViewHolder;
    }

    private void setHolderView(View holderView) {
        this.mViewHolder = holderView;
    }

    private RelativeLayout getHolder() {
        return this.mRlyHolder;
    }

    private void setHolder(RelativeLayout holder) {
        this.mRlyHolder = holder;
    }

    boolean isKeyboardAutoPopOnSearch() {
        return this.mKeyboardAutoPopOnSearch;
    }

    public void setKeyboardAutoPopOnSearch(boolean keyboardAutoPopOnSearch) {
        this.mKeyboardAutoPopOnSearch = keyboardAutoPopOnSearch;
    }

    EditText getEdtRegisteredCarrierNumber() {
        return this.mEdtRegisteredCarrierNumber;
    }

    void setEdtRegisteredCarrierNumber(AppCompatEditText edtRegisteredCarrierNumber) {
        this.mEdtRegisteredCarrierNumber = edtRegisteredCarrierNumber;
    }

    private LayoutInflater getInflater() {
        return this.mInflater;
    }

    private View.OnClickListener getCountryCodeHolderClickListener() {
        return this.countryCodeHolderClickListener;
    }

    void refreshPreferredCountries() {
        if (this.mCountryPreference == null || this.mCountryPreference.length() == 0) {
            this.mPreferredCountries = null;
        } else {
            ArrayList<Country> localCountryList = new ArrayList<Country>();
            for (String nameCode : this.mCountryPreference.split(",")) {
                Country country = CountryUtils.getCountryByNameCodeFromCustomCountries(this.getContext(), this.mCustomMasterCountriesList, nameCode);
                if (country == null || this.isAlreadyInList(country, localCountryList)) continue;
                localCountryList.add(country);
            }
            this.mPreferredCountries = localCountryList.size() == 0 ? null : localCountryList;
        }
        if (this.mPreferredCountries != null) {
            for (Country country : this.mPreferredCountries) {
                country.log();
            }
        }
    }

    void refreshCustomMasterList() {
        if (this.mCustomMasterCountries == null || this.mCustomMasterCountries.length() == 0) {
            this.mCustomMasterCountriesList = null;
        } else {
            ArrayList<Country> localCountryList = new ArrayList<Country>();
            for (String nameCode : this.mCustomMasterCountries.split(",")) {
                Country country = CountryUtils.getCountryByNameCodeFromAllCountries(this.getContext(), nameCode);
                if (country == null || this.isAlreadyInList(country, localCountryList)) continue;
                localCountryList.add(country);
            }
            this.mCustomMasterCountriesList = localCountryList.size() == 0 ? null : localCountryList;
        }
        if (this.mCustomMasterCountriesList != null) {
            for (Country country : this.mCustomMasterCountriesList) {
                country.log();
            }
        }
    }

    List<Country> getCustomCountries() {
        return this.mCustomMasterCountriesList;
    }

    List<Country> getCustomCountries(CountryCodePicker codePicker) {
        codePicker.refreshCustomMasterList();
        if (codePicker.getCustomCountries() != null && codePicker.getCustomCountries().size() > 0) {
            return codePicker.getCustomCountries();
        }
        return CountryUtils.getAllCountries(codePicker.getContext());
    }

    void setCustomMasterCountriesList(List<Country> mCustomMasterCountriesList) {
        this.mCustomMasterCountriesList = mCustomMasterCountriesList;
    }

    String getCustomMasterCountries() {
        return this.mCustomMasterCountries;
    }

    public List<Country> getPreferredCountries() {
        return this.mPreferredCountries;
    }

    public void setCustomMasterCountries(String customMasterCountries) {
        this.mCustomMasterCountries = customMasterCountries;
    }

    private boolean isAlreadyInList(Country country, List<Country> countryList) {
        if (country != null && countryList != null) {
            for (Country iterationCountry : countryList) {
                if (!iterationCountry.getNameCode().equalsIgnoreCase(country.getNameCode())) continue;
                return true;
            }
        }
        return false;
    }

    private String detectCarrierNumber(String fullNumber, Country country) {
        int indexOfCode;
        String carrierNumber = country == null || fullNumber == null ? fullNumber : ((indexOfCode = fullNumber.indexOf(country.getPhoneCode())) == -1 ? fullNumber : fullNumber.substring(indexOfCode + country.getPhoneCode().length()));
        return carrierNumber;
    }

    @Deprecated
    public void setDefaultCountryUsingPhoneCode(int defaultCountryCode) {
        Country defaultCountry = CountryUtils.getCountryByCode(this.getContext(), this.mPreferredCountries, defaultCountryCode);
        if (defaultCountry != null) {
            this.mDefaultCountryCode = defaultCountryCode;
            this.setDefaultCountry(defaultCountry);
        }
    }

    public void setDefaultCountryUsingNameCode(String defaultCountryNameCode) {
        Country defaultCountry = CountryUtils.getCountryByNameCodeFromAllCountries(this.getContext(), defaultCountryNameCode);
        if (defaultCountry != null) {
            this.mDefaultCountryNameCode = defaultCountry.getNameCode();
            this.setDefaultCountry(defaultCountry);
        }
    }

    public String getDefaultCountryCode() {
        return this.mDefaultCountry.getPhoneCode();
    }

    public int getDefaultCountryCodeAsInt() {
        int code = 0;
        try {
            code = Integer.parseInt(this.getDefaultCountryCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    public String getDefaultCountryCodeWithPlus() {
        return "+" + this.getDefaultCountryCode();
    }

    public String getDefaultCountryName() {
        return this.getDefaultCountry().getName();
    }

    public String getDefaultCountryNameCode() {
        return this.getDefaultCountry().getNameCode().toUpperCase();
    }

    public void resetToDefaultCountry() {
        this.setSelectedCountry(this.mDefaultCountry);
    }

    public String getSelectedCountryCode() {
        return this.getSelectedCountry().getPhoneCode();
    }

    public String getSelectedCountryCodeWithPlus() {
        return this.getContext().getString(R.string.phone_code, new Object[]{this.getSelectedCountryCode()});
    }

    public int getSelectedCountryCodeAsInt() {
        int code = 0;
        try {
            code = Integer.parseInt(this.getSelectedCountryCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    public String getSelectedCountryName() {
        return this.getSelectedCountry().getName();
    }

    public String getSelectedCountryNameCode() {
        return this.getSelectedCountry().getNameCode().toUpperCase();
    }

    public void setCountryForPhoneCode(int countryCode) {
        Country country = CountryUtils.getCountryByCode(this.getContext(), this.mPreferredCountries, countryCode);
        if (country == null) {
            if (this.mDefaultCountry == null) {
                this.mDefaultCountry = CountryUtils.getCountryByCode(this.getContext(), this.mPreferredCountries, this.mDefaultCountryCode);
            }
            this.setSelectedCountry(this.mDefaultCountry);
        } else {
            this.setSelectedCountry(country);
        }
    }

    public void setCountryForNameCode(String countryNameCode) {
        Country country = CountryUtils.getCountryByNameCodeFromAllCountries(this.getContext(), countryNameCode);
        if (country == null) {
            if (this.mDefaultCountry == null) {
                this.mDefaultCountry = CountryUtils.getCountryByCode(this.getContext(), this.mPreferredCountries, this.mDefaultCountryCode);
            }
            this.setSelectedCountry(this.mDefaultCountry);
        } else {
            this.setSelectedCountry(country);
        }
    }

    public void registerCarrierNumberEditText(AppCompatEditText editTextCarrierNumber) {
        this.setEdtRegisteredCarrierNumber(editTextCarrierNumber);
    }

    public String getFullNumber() {
        String fullNumber;
        if (this.mEdtRegisteredCarrierNumber != null) {
            fullNumber = this.getSelectedCountry().getPhoneCode() + this.mEdtRegisteredCarrierNumber.getText().toString();
        } else {
            fullNumber = this.getSelectedCountry().getPhoneCode();
            Log.w((String)TAG, (String)"EditText for carrier number is not registered. Register it using registerCarrierNumberEditText() before getFullNumber() or setFullNumber().");
        }
        return fullNumber;
    }

    public void setFullNumber(String fullNumber) {
        Country country = CountryUtils.getCountryByNumber(this.getContext(), this.mPreferredCountries, fullNumber);
        this.setSelectedCountry(country);
        String carrierNumber = this.detectCarrierNumber(fullNumber, country);
        if (this.getEdtRegisteredCarrierNumber() != null) {
            this.getEdtRegisteredCarrierNumber().setText((CharSequence)carrierNumber);
        } else {
            Log.w((String)TAG, (String)"EditText for carrier number is not registered. Register it using registerCarrierNumberEditText() before getFullNumber() or setFullNumber().");
        }
    }

    public String getFullNumberWithPlus() {
        return "+" + this.getFullNumber();
    }

    public int getContentColor() {
        return this.mContentColor;
    }

    public void setContentColor(int contentColor) {
        this.mContentColor = contentColor;
        this.mTvSelectedCountry.setTextColor(this.mContentColor);
        this.mImvArrow.setColorFilter(this.mContentColor, PorterDuff.Mode.SRC_IN);
    }

    public void setTextSize(int textSize) {
        if (textSize > 0) {
            this.mTvSelectedCountry.setTextSize(0, (float)textSize);
            this.setArrowSize(textSize);
            this.setFlagSize(textSize);
        }
    }

    private void setArrowSize(int arrowSize) {
        if (arrowSize > 0) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mImvArrow.getLayoutParams();
            params.width = arrowSize;
            params.height = arrowSize;
            this.mImvArrow.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    public void hideNameCode(boolean hideNameCode) {
        this.mHideNameCode = hideNameCode;
        this.setSelectedCountry(this.mSelectedCountry);
    }

    public void setmCountryPreference(String mCountryPreference) {
        this.mCountryPreference = mCountryPreference;
    }

    public void setTypeFace(Typeface typeFace) {
        this.mTypeFace = typeFace;
        try {
            this.mTvSelectedCountry.setTypeface(typeFace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTypeFace(String fontAssetPath) {
        try {
            Typeface typeFace;
            this.mTypeFace = typeFace = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)fontAssetPath);
            this.mTvSelectedCountry.setTypeface(typeFace);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Invalid fontPath. " + e.toString()));
        }
    }

    public void setTypeFace(Typeface typeFace, int style) {
        try {
            this.mTvSelectedCountry.setTypeface(typeFace, style);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Typeface getTypeFace() {
        return this.mTypeFace;
    }

    public void setOnCountryChangeListener(OnCountryChangeListener onCountryChangeListener) {
        this.onCountryChangeListener = onCountryChangeListener;
    }

    public void setFlagSize(int flagSize) {
        this.mImvFlag.getLayoutParams().height = flagSize;
        this.mImvFlag.requestLayout();
    }

    public void showFlag(boolean showFlag) {
        this.mShowFlag = showFlag;
        if (showFlag) {
            this.mLlyFlagHolder.setVisibility(0);
        } else {
            this.mLlyFlagHolder.setVisibility(8);
        }
    }

    public void showFullName(boolean showFullName) {
        this.mShowFullName = showFullName;
        this.setSelectedCountry(this.mSelectedCountry);
    }

    public boolean isSelectionDialogShowSearch() {
        return this.mSelectionDialogShowSearch;
    }

    public void setSelectionDialogShowSearch(boolean selectionDialogShowSearch) {
        this.mSelectionDialogShowSearch = selectionDialogShowSearch;
    }

    public boolean isClickable() {
        return this.mIsClickable;
    }

    public void setClickable(boolean isClickable) {
        this.mIsClickable = isClickable;
        if (!isClickable) {
            this.mRlyClickConsumer.setOnClickListener(null);
            this.mRlyClickConsumer.setClickable(false);
            this.mRlyClickConsumer.setEnabled(false);
        } else {
            this.mRlyClickConsumer.setOnClickListener(this.countryCodeHolderClickListener);
            this.mRlyClickConsumer.setClickable(true);
            this.mRlyClickConsumer.setEnabled(true);
        }
    }

    public static interface OnCountryChangeListener {
        public void onCountrySelected();
    }
}

