/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.app.Dialog;
import android.content.Context;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.rilixtech.Country;
import com.rilixtech.CountryCodePicker;
import com.rilixtech.R;
import java.util.ArrayList;
import java.util.List;

class CountryCodeAdapter
extends RecyclerView.Adapter<CountryCodeViewHolder> {
    private List<Country> filteredCountries = null;
    private List<Country> masterCountries = null;
    private AppCompatTextView mTvNoResult;
    private CountryCodePicker mCountryCodePicker;
    private AppCompatEditText mEdtSearch;
    private Dialog mDialog;
    private InputMethodManager mInputMethodManager;

    CountryCodeAdapter(List<Country> countries, CountryCodePicker codePicker, AppCompatEditText edtSearch, AppCompatTextView tvNoResult, Dialog dialog) {
        this.masterCountries = countries;
        this.mCountryCodePicker = codePicker;
        this.mDialog = dialog;
        this.mTvNoResult = tvNoResult;
        this.mEdtSearch = edtSearch;
        this.filteredCountries = this.getFilteredCountries();
        this.mInputMethodManager = (InputMethodManager)this.mCountryCodePicker.getContext().getSystemService("input_method");
        this.setSearchBar();
    }

    private void setSearchBar() {
        if (this.mCountryCodePicker.isSelectionDialogShowSearch()) {
            this.setTextWatcher();
        } else {
            this.mEdtSearch.setVisibility(8);
        }
    }

    private void setTextWatcher() {
        if (this.mEdtSearch != null) {
            this.mEdtSearch.addTextChangedListener(new TextWatcher(){

                public void afterTextChanged(Editable s) {
                }

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    CountryCodeAdapter.this.applyQuery(s.toString());
                }
            });
            if (this.mCountryCodePicker.isKeyboardAutoPopOnSearch() && this.mInputMethodManager != null) {
                this.mInputMethodManager.toggleSoftInput(2, 0);
            }
        }
    }

    private void applyQuery(String query) {
        this.mTvNoResult.setVisibility(8);
        query = query.toLowerCase();
        if (query.length() > 0 && query.charAt(0) == '+') {
            query = query.substring(1);
        }
        this.filteredCountries = this.getFilteredCountries(query);
        if (this.filteredCountries.size() == 0) {
            this.mTvNoResult.setVisibility(0);
        }
        this.notifyDataSetChanged();
    }

    private List<Country> getFilteredCountries() {
        return this.getFilteredCountries("");
    }

    private List<Country> getFilteredCountries(String query) {
        ArrayList<Country> tempCountryList = new ArrayList<Country>();
        List<Country> preferredCountries = this.mCountryCodePicker.getPreferredCountries();
        if (preferredCountries != null && preferredCountries.size() > 0) {
            for (Country country : preferredCountries) {
                if (!country.isEligibleForQuery(query)) continue;
                tempCountryList.add(country);
            }
            if (tempCountryList.size() > 0) {
                Object divider = null;
                tempCountryList.add((Country)divider);
            }
        }
        for (Country country : this.masterCountries) {
            if (!country.isEligibleForQuery(query)) continue;
            tempCountryList.add(country);
        }
        return tempCountryList;
    }

    public CountryCodeViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        LayoutInflater inflater = LayoutInflater.from((Context)viewGroup.getContext());
        View rootView = inflater.inflate(R.layout.layout_recycler_country_tile, viewGroup, false);
        return new CountryCodeViewHolder(rootView);
    }

    public void onBindViewHolder(CountryCodeViewHolder viewHolder, int i) {
        final int position = viewHolder.getAdapterPosition();
        viewHolder.setCountry(this.filteredCountries.get(position));
        viewHolder.rlyMain.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CountryCodeAdapter.this.mCountryCodePicker.setSelectedCountry((Country)CountryCodeAdapter.this.filteredCountries.get(position));
                if (view != null && CountryCodeAdapter.this.filteredCountries.get(position) != null) {
                    CountryCodeAdapter.this.mInputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
                    CountryCodeAdapter.this.mDialog.dismiss();
                }
            }
        });
    }

    public int getItemCount() {
        return this.filteredCountries.size();
    }

    class CountryCodeViewHolder
    extends RecyclerView.ViewHolder {
        RelativeLayout rlyMain;
        AppCompatTextView tvName;
        AppCompatTextView tvCode;
        AppCompatImageView imvFlag;
        LinearLayout llyFlagHolder;
        View viewDivider;

        CountryCodeViewHolder(View itemView) {
            super(itemView);
            this.rlyMain = (RelativeLayout)itemView;
            this.tvName = (AppCompatTextView)this.rlyMain.findViewById(R.id.country_name_tv);
            this.tvCode = (AppCompatTextView)this.rlyMain.findViewById(R.id.code_tv);
            this.imvFlag = (AppCompatImageView)this.rlyMain.findViewById(R.id.flag_imv);
            this.llyFlagHolder = (LinearLayout)this.rlyMain.findViewById(R.id.flag_holder_lly);
            this.viewDivider = this.rlyMain.findViewById(R.id.preference_divider_view);
        }

        public void setCountry(Country country) {
            if (country != null) {
                this.viewDivider.setVisibility(8);
                this.tvName.setVisibility(0);
                this.tvCode.setVisibility(0);
                this.llyFlagHolder.setVisibility(0);
                String countryNameAndCode = this.tvName.getContext().getString(R.string.country_name_and_code, new Object[]{country.getName(), country.getNameCode().toUpperCase()});
                this.tvName.setText((CharSequence)countryNameAndCode);
                this.tvCode.setText((CharSequence)this.tvCode.getContext().getString(R.string.phone_code, new Object[]{country.getPhoneCode()}));
                if (CountryCodeAdapter.this.mCountryCodePicker.getTypeFace() != null) {
                    this.tvCode.setTypeface(CountryCodeAdapter.this.mCountryCodePicker.getTypeFace());
                    this.tvName.setTypeface(CountryCodeAdapter.this.mCountryCodePicker.getTypeFace());
                }
                this.imvFlag.setImageResource(country.getFlagDrawableResId());
            } else {
                this.viewDivider.setVisibility(0);
                this.tvName.setVisibility(8);
                this.tvCode.setVisibility(8);
                this.llyFlagHolder.setVisibility(8);
            }
        }
    }
}

