/*
 * Decompiled with CFR 0.152.
 */
package com.rilixtech;

import android.util.Log;
import com.rilixtech.CountryUtils;

class Country {
    private static String TAG = Country.class.getSimpleName();
    private String nameCode;
    private String phoneCode;
    private String name;

    public Country() {
    }

    public Country(String nameCode, String phoneCode, String name) {
        this.nameCode = nameCode;
        this.phoneCode = phoneCode;
        this.name = name;
    }

    public String getNameCode() {
        return this.nameCode;
    }

    public void setNameCode(String nameCode) {
        this.nameCode = nameCode;
    }

    public String getPhoneCode() {
        return this.phoneCode;
    }

    public void setPhoneCode(String phoneCode) {
        this.phoneCode = phoneCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getFlagDrawableResId() {
        return CountryUtils.getFlagDrawableResId(this);
    }

    public void log() {
        try {
            Log.d((String)TAG, (String)("Country->" + this.nameCode + ":" + this.phoneCode + ":" + this.name));
        }
        catch (NullPointerException ex) {
            Log.d((String)TAG, (String)"Null");
        }
    }

    public String logString() {
        return this.nameCode.toUpperCase() + " +" + this.phoneCode + "(" + this.name + ")";
    }

    public boolean isEligibleForQuery(String query) {
        query = query.toLowerCase();
        return this.getName().toLowerCase().contains(query) || this.getNameCode().toLowerCase().contains(query) || this.getPhoneCode().toLowerCase().contains(query);
    }
}

