/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.gradle.publish;

import java.lang.reflect.Method;
import org.gradle.plugin.devel.PluginDeclaration;
import shadow.com.gradle.publish.PluginConfig;

class PluginDeclarationAccessor {
    private static final Method GET_DISPLAY_NAME_METHOD = PluginDeclarationAccessor.findOptionalGetter("getDisplayName");
    private static final Method GET_DESCRIPTION_METHOD = PluginDeclarationAccessor.findOptionalGetter("getDescription");
    private final PluginDeclaration delegate;

    PluginDeclarationAccessor(PluginDeclaration delegate) {
        this.delegate = delegate;
    }

    void configureDefaults(PluginConfig pluginConfig) {
        if (pluginConfig.getId() == null) {
            pluginConfig.setId(this.getId());
        }
        if (pluginConfig.getDisplayName() == null) {
            pluginConfig.setDisplayName(this.getDisplayName());
        }
        if (pluginConfig.getDescription() == null) {
            pluginConfig.setDescription(this.getDescription());
        }
    }

    private String getId() {
        return this.delegate.getId();
    }

    private String getDisplayName() {
        return (String)this.invokeSafely(GET_DISPLAY_NAME_METHOD);
    }

    private String getDescription() {
        return (String)this.invokeSafely(GET_DESCRIPTION_METHOD);
    }

    private Object invokeSafely(Method getterMethod) {
        if (getterMethod == null) {
            return null;
        }
        try {
            return getterMethod.invoke((Object)this.delegate, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling " + getterMethod.getName(), e);
        }
    }

    private static Method findOptionalGetter(String methodName) {
        try {
            return PluginDeclaration.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }
}

