/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.gradle.publish;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import shadow.com.gradle.protocols.ServerResponseBase;
import shadow.com.gradle.publish.RequestUtil;
import shadow.com.gradle.publish.ResponseUtil;
import shadow.com.gradle.publish.Util;
import shadow.com.gradle.publish.plugin.dep.oauth.signpost.basic.DefaultOAuthConsumer;
import shadow.com.gradle.publish.plugin.dep.oauth.signpost.exception.OAuthException;
import shadow.com.gradle.publish.plugin.dep.org.apache.commons.io.IOUtils;
import shadow.com.gradle.publish.protocols.v1.models.ClientPostRequest;

public class OAuthHttpClient {
    private static final Logger LOGGER = Logging.getLogger(OAuthHttpClient.class);
    private static final String UTF_8 = "UTF-8";
    private static final String CONSUMER_KEY = "gradle";
    private static final String CONSUMER_SECRET = "gradle";
    private final URI baseUrl;
    private final String publishKey;
    private final String publishSecret;

    public OAuthHttpClient(String baseUrl, String publishKey, String publishSecret) {
        this.baseUrl = URI.create(baseUrl);
        this.publishKey = publishKey;
        this.publishSecret = publishSecret;
    }

    private void sign(HttpURLConnection con) {
        DefaultOAuthConsumer consumer = new DefaultOAuthConsumer("gradle", "gradle");
        consumer.setTokenWithSecret(this.publishKey, this.publishSecret);
        try {
            consumer.sign(con);
        }
        catch (OAuthException e) {
            throw new RuntimeException("Error signing request", e);
        }
    }

    public <T extends ServerResponseBase> T send(ClientPostRequest<T> postRequest) throws Exception {
        String requestJson = postRequest.getPostJsonString();
        byte[] requestBytes = requestJson.getBytes(UTF_8);
        URL url = this.baseUrl.resolve(postRequest.requestProtocolURL()).toURL();
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.addRequestProperty("Content-Type", postRequest.getContentType());
        con.addRequestProperty("Content-Length", String.valueOf(requestBytes.length));
        RequestUtil.addClientVersionAsRequestHeader(con);
        this.sign(con);
        con.connect();
        try (OutputStream os = con.getOutputStream();){
            os.write(requestBytes);
        }
        int statusCode = con.getResponseCode();
        boolean error = statusCode >= 400 || statusCode < 200;
        String responseJson = IOUtils.toString(error ? con.getErrorStream() : con.getInputStream(), UTF_8);
        LOGGER.debug("Signed post response with code: " + statusCode + " was: " + responseJson);
        ServerResponseBase apiResponse = (ServerResponseBase)Util.convertResponse(postRequest, url.toExternalForm(), responseJson, statusCode);
        if (statusCode == 401) {
            throw new RuntimeException("Unauthorized!\n  Login from command line using:\n    gradle login\n  or login and download user API keys on:\n    " + this.baseUrl + "/user/login");
        }
        if (error) {
            ResponseUtil.assertValidResponse("Failed to post to server.", apiResponse);
        }
        return (T)apiResponse;
    }
}

