/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.gradle.publish;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.gradle.publish.AugmentedCoordinatesModuleDependency;
import shadow.com.gradle.publish.MavenCoordinates;
import shadow.org.apache.maven.model.Dependency;
import shadow.org.apache.maven.model.Exclusion;

public class DependenciesBuilder {
    private static final String API_ELEMENTS = "apiElements";
    private static final String RUNTIME_ELEMENTS = "runtimeElements";
    private static final Logger LOGGER = LoggerFactory.getLogger(DependenciesBuilder.class);

    public List<Dependency> buildMavenDependencies(ConfigurationContainer configurations) {
        Configuration compileConfig = configurations.getByName(API_ELEMENTS);
        Configuration runtimeConfig = configurations.getByName(RUNTIME_ELEMENTS);
        return this.getDependencies(compileConfig, runtimeConfig);
    }

    private List<Dependency> getDependencies(Configuration compileConfig, Configuration runtimeConfig) {
        ArrayList<Dependency> mavenDependencies = new ArrayList<Dependency>();
        this.addUniqueScopedDependencies(mavenDependencies, compileConfig, "compile");
        this.addUniqueScopedDependencies(mavenDependencies, runtimeConfig, "runtime");
        return mavenDependencies;
    }

    private void addUniqueScopedDependencies(List<Dependency> mavenDependencies, Configuration config, String scope) {
        for (org.gradle.api.artifacts.Dependency dependency : config.getAllDependencies()) {
            Object refinedDependency = dependency instanceof ProjectDependency ? this.preparePublishedProjectDependency((ProjectDependency)dependency) : dependency;
            if (!(refinedDependency instanceof ModuleDependency) || this.isDuplicateDependency(mavenDependencies, (ModuleDependency)refinedDependency)) continue;
            this.addDependency(mavenDependencies, (ModuleDependency)refinedDependency, scope);
        }
    }

    private ModuleDependency preparePublishedProjectDependency(ProjectDependency projectDependency) {
        Project project = projectDependency.getDependencyProject();
        PublishingExtension publishingExtension = (PublishingExtension)project.getExtensions().findByType(PublishingExtension.class);
        MavenCoordinates coordinates = publishingExtension == null ? this.mavenCoordinatesFromDependencyProject(project) : this.mavenCoordinatesFromPublications(project, publishingExtension);
        return AugmentedCoordinatesModuleDependency.augment((ModuleDependency)projectDependency, coordinates);
    }

    private MavenCoordinates mavenCoordinatesFromPublications(Project project, PublishingExtension publishingExtension) {
        PublicationContainer publications = publishingExtension.getPublications();
        MavenPublication mavenPublication = (MavenPublication)publications.iterator().next();
        this.logIfPublicationAmbiguous(project, publications, mavenPublication);
        return new MavenCoordinates(mavenPublication.getGroupId(), mavenPublication.getArtifactId(), mavenPublication.getVersion());
    }

    private void logIfPublicationAmbiguous(Project project, PublicationContainer publications, MavenPublication mavenPublication) {
        if (publications.size() > 1) {
            LOGGER.warn("Plugin depends on project '{}', but project has multiple Maven publications. Will use first publication ({}) as dependency in POM.", (Object)project.getPath(), (Object)this.buildCoordinateString(mavenPublication));
        }
    }

    private String buildCoordinateString(MavenPublication publication) {
        return publication.getGroupId() + ":" + publication.getArtifactId() + ":" + publication.getVersion();
    }

    private MavenCoordinates mavenCoordinatesFromDependencyProject(Project project) {
        return new MavenCoordinates(project.getGroup().toString(), project.getName(), project.getVersion().toString());
    }

    private boolean isDuplicateDependency(List<Dependency> mavenDependencies, ModuleDependency dependency) {
        for (Dependency mavenDependency : mavenDependencies) {
            if (!mavenDependency.getGroupId().equals(dependency.getGroup()) || !mavenDependency.getArtifactId().equals(dependency.getName()) || !this.hasEqualOrNullVersions(mavenDependency, dependency)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEqualOrNullVersions(Dependency mavenDependency, ModuleDependency moduleDependency) {
        return mavenDependency.getVersion() == moduleDependency.getVersion();
    }

    private void addDependency(List<Dependency> mavenDependencies, ModuleDependency moduleDependency, String scope) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(moduleDependency.getGroup());
        mavenDependency.setArtifactId(moduleDependency.getName());
        mavenDependency.setVersion(moduleDependency.getVersion());
        mavenDependency.setScope(scope);
        this.logTransitiveDependency(moduleDependency);
        this.addExclusions(mavenDependency, moduleDependency);
        mavenDependencies.add(mavenDependency);
    }

    private void addExclusions(Dependency mavenDependency, ModuleDependency moduleDependency) {
        Set excludeRules = moduleDependency.getExcludeRules();
        if (excludeRules != null) {
            for (ExcludeRule excludeRule : excludeRules) {
                Exclusion mavenExclusion = new Exclusion();
                mavenExclusion.setGroupId(excludeRule.getGroup());
                mavenExclusion.setArtifactId(excludeRule.getModule());
                mavenDependency.addExclusion(mavenExclusion);
            }
        }
    }

    private void logTransitiveDependency(ModuleDependency moduleDependency) {
        if (!moduleDependency.isTransitive()) {
            LOGGER.warn("Dependency {}:{}:{} is marked as non-transitive, but this is not supported by the underlying Maven publishing mechanism", new Object[]{moduleDependency.getGroup(), moduleDependency.getName(), moduleDependency.getVersion()});
        }
    }
}

