/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.gradle.publish;

import org.gradle.api.Project;

class Config {
    public static final String PORTAL_URL_PROPERTY_ENV = "GRADLE_PORTAL_URL";
    public static final String PORTAL_URL_PROPERTY = "gradle.portal.url";
    public static final String VERSION_OVERRIDE_PROPERTY = "gradle.portal.version.override";
    private final Project project;
    private final String gradleVersion;
    private String version;

    public Config(Project project) {
        this.project = project;
        this.gradleVersion = project.getGradle().getGradleVersion();
    }

    public String getPortalUrl() {
        String inEnv = System.getenv(PORTAL_URL_PROPERTY_ENV);
        if (inEnv == null) {
            return System.getProperty(PORTAL_URL_PROPERTY, "https://plugins.gradle.org");
        }
        return inEnv;
    }

    public String getGradleVersion() {
        return this.gradleVersion;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.project.getVersion().toString();
        }
        return this.version;
    }

    public Long loginSleepInterval() {
        return Long.parseLong(System.getProperty("gradle.portal.login.sleep", "500"));
    }

    public Long loginMaxWait() {
        return Long.parseLong(System.getProperty("gradle.portal.login.wait", "300000"));
    }

    public Boolean versionOverride() {
        return Boolean.parseBoolean(System.getProperty(VERSION_OVERRIDE_PROPERTY, "false"));
    }
}

