/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs.email;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.taskdefs.email.Header;
import shadow.org.apache.tools.ant.taskdefs.email.Mailer;
import shadow.org.apache.tools.mail.MailMessage;

class PlainMailer
extends Mailer {
    PlainMailer() {
    }

    public void send() {
        try {
            String to;
            MailMessage mailMessage = new MailMessage(this.host, this.port);
            mailMessage.from(this.from.toString());
            boolean atLeastOneRcptReached = false;
            Enumeration e = this.replyToList.elements();
            while (e.hasMoreElements()) {
                mailMessage.replyto(e.nextElement().toString());
            }
            e = this.toList.elements();
            while (e.hasMoreElements()) {
                to = e.nextElement().toString();
                try {
                    mailMessage.to(to);
                    atLeastOneRcptReached = true;
                }
                catch (IOException ex) {
                    this.badRecipient(to, ex);
                }
            }
            e = this.ccList.elements();
            while (e.hasMoreElements()) {
                to = e.nextElement().toString();
                try {
                    mailMessage.cc(to);
                    atLeastOneRcptReached = true;
                }
                catch (IOException ex) {
                    this.badRecipient(to, ex);
                }
            }
            e = this.bccList.elements();
            while (e.hasMoreElements()) {
                to = e.nextElement().toString();
                try {
                    mailMessage.bcc(to);
                    atLeastOneRcptReached = true;
                }
                catch (IOException ex) {
                    this.badRecipient(to, ex);
                }
            }
            if (!atLeastOneRcptReached) {
                throw new BuildException("Couldn't reach any recipient");
            }
            if (this.subject != null) {
                mailMessage.setSubject(this.subject);
            }
            mailMessage.setHeader("Date", this.getDate());
            if (this.message.getCharset() != null) {
                mailMessage.setHeader("Content-Type", this.message.getMimeType() + "; charset=\"" + this.message.getCharset() + "\"");
            } else {
                mailMessage.setHeader("Content-Type", this.message.getMimeType());
            }
            if (this.headers != null) {
                e = this.headers.elements();
                while (e.hasMoreElements()) {
                    Header h = (Header)e.nextElement();
                    mailMessage.setHeader(h.getName(), h.getValue());
                }
            }
            PrintStream out = mailMessage.getPrintStream();
            this.message.print(out);
            e = this.files.elements();
            while (e.hasMoreElements()) {
                this.attach((File)e.nextElement(), out);
            }
            mailMessage.sendAndClose();
        }
        catch (IOException ioe) {
            throw new BuildException("IO error sending mail", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attach(File file, PrintStream out) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new BuildException("File \"" + file.getName() + "\" does not exist or is not " + "readable.");
        }
        if (this.includeFileNames) {
            out.println();
            String filename = file.getName();
            int filenamelength = filename.length();
            out.println(filename);
            for (int star = 0; star < filenamelength; ++star) {
                out.print('=');
            }
            out.println();
        }
        int maxBuf = 1024;
        byte[] buf = new byte[1024];
        FileInputStream finstr = new FileInputStream(file);
        try {
            int length;
            BufferedInputStream in = new BufferedInputStream(finstr, buf.length);
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        finally {
            finstr.close();
        }
    }

    private void badRecipient(String rcpt, IOException reason) {
        String msg = "Failed to send mail to " + rcpt;
        if (this.shouldIgnoreInvalidRecipients()) {
            msg = msg + " because of :" + reason.getMessage();
            if (this.task != null) {
                this.task.log(msg, 1);
            } else {
                System.err.println(msg);
            }
        } else {
            throw new BuildException(msg, reason);
        }
    }
}

