/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.geometry;

import net.morbz.osmonaut.osm.LatLon;
import net.morbz.osmonaut.util.StringUtil;

public class Bounds {
    private double minLat = Double.MAX_VALUE;
    private double maxLat = -1.7976931348623157E308;
    private double minLon = Double.MAX_VALUE;
    private double maxLon = -1.7976931348623157E308;
    private boolean initialized = false;

    public Bounds() {
    }

    public Bounds(double lat1, double lat2, double lon1, double lon2) {
        this.initialized = true;
        this.minLat = Math.min(lat1, lat2);
        this.maxLat = Math.max(lat1, lat2);
        this.minLon = Math.min(lon1, lon2);
        this.maxLon = Math.max(lon1, lon2);
    }

    public void extend(LatLon latlon) {
        this.initialized = true;
        this.minLat = Math.min(this.minLat, latlon.getLat());
        this.minLon = Math.min(this.minLon, latlon.getLon());
        this.maxLat = Math.max(this.maxLat, latlon.getLat());
        this.maxLon = Math.max(this.maxLon, latlon.getLon());
    }

    public void extend(Bounds bounds) {
        this.initialized = true;
        this.minLat = Math.min(this.minLat, bounds.getMinLat());
        this.minLon = Math.min(this.minLon, bounds.getMinLon());
        this.maxLat = Math.max(this.maxLat, bounds.getMaxLat());
        this.maxLon = Math.max(this.maxLon, bounds.getMaxLon());
    }

    public LatLon getCenter() {
        if (!this.initialized) {
            return null;
        }
        return new LatLon((this.minLat + this.maxLat) / 2.0, (this.minLon + this.maxLon) / 2.0);
    }

    public boolean contains(LatLon latlon) {
        if (!this.initialized) {
            return false;
        }
        if (latlon.getLat() < this.minLat) {
            return false;
        }
        if (latlon.getLat() > this.maxLat) {
            return false;
        }
        if (latlon.getLon() < this.minLon) {
            return false;
        }
        return !(latlon.getLon() > this.maxLon);
    }

    public double getMinLat() {
        if (!this.initialized) {
            return 0.0;
        }
        return this.minLat;
    }

    public double getMaxLat() {
        if (!this.initialized) {
            return 0.0;
        }
        return this.maxLat;
    }

    public double getMinLon() {
        if (!this.initialized) {
            return 0.0;
        }
        return this.minLon;
    }

    public double getMaxLon() {
        if (!this.initialized) {
            return 0.0;
        }
        return this.maxLon;
    }

    public String toString() {
        return "{ minLat: " + StringUtil.formatCoordinate(this.getMinLat()) + ", minLon: " + StringUtil.formatCoordinate(this.getMinLon()) + ", maxLat: " + StringUtil.formatCoordinate(this.getMaxLat()) + ", maxLon: " + StringUtil.formatCoordinate(this.getMaxLon()) + " }";
    }
}

