/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.osm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import net.morbz.osmonaut.geometry.Bounds;
import net.morbz.osmonaut.geometry.Polygon;
import net.morbz.osmonaut.osm.Entity;
import net.morbz.osmonaut.osm.EntityType;
import net.morbz.osmonaut.osm.LatLon;
import net.morbz.osmonaut.osm.Node;
import net.morbz.osmonaut.osm.Tags;
import net.morbz.osmonaut.util.StringUtil;

public class Way
extends Entity {
    private List<Node> nodes;

    public Way(long id, Tags tags, List<Node> nodes) {
        super(id, tags);
        this.nodes = nodes;
    }

    public Way() {
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.WAY;
    }

    @Override
    public LatLon getCenter() {
        Polygon poly = new Polygon(this);
        return poly.getCenter();
    }

    @Override
    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        for (Node node : this.nodes) {
            bounds.extend(node.getLatlon());
        }
        return bounds;
    }

    public boolean isClosed() {
        if (this.nodes.size() <= 2) {
            return false;
        }
        return this.nodes.get(0).equals(this.nodes.get(this.nodes.size() - 1));
    }

    public String toString() {
        String str = "";
        str = str + "{\tWAY\n";
        str = str + "\tid: " + this.id + "\n";
        str = str + "\ttags: " + StringUtil.indent(this.getTags().toString());
        str = str + "\tnodes: [\n";
        for (Node node : this.nodes) {
            str = str + StringUtil.indent(StringUtil.indent(node.toString()));
        }
        str = str + "\t]\n";
        str = str + "}";
        return str;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.nodes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.nodes = (List)in.readObject();
    }
}

