/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.osm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.morbz.osmonaut.geometry.Bounds;
import net.morbz.osmonaut.osm.Entity;
import net.morbz.osmonaut.osm.EntityType;
import net.morbz.osmonaut.osm.LatLon;
import net.morbz.osmonaut.osm.Tags;
import net.morbz.osmonaut.util.StringUtil;

public class Node
extends Entity {
    private double lat = Double.NaN;
    private double lon = Double.NaN;

    public Node(long id, Tags tags, LatLon latlon) {
        super(id, tags);
        if (latlon != null) {
            this.lat = latlon.getLat();
            this.lon = latlon.getLon();
        }
    }

    public Node() {
    }

    public LatLon getLatlon() {
        if (Double.isNaN(this.lat)) {
            return null;
        }
        return new LatLon(this.lat, this.lon);
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.NODE;
    }

    @Override
    public LatLon getCenter() {
        return this.getLatlon();
    }

    @Override
    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        bounds.extend(this.getLatlon());
        return bounds;
    }

    public String toString() {
        String str = "";
        str = str + "{\tNODE\n";
        str = str + "\tid: " + this.id + "\n";
        str = str + "\tlatlon: " + this.getLatlon() + "\n";
        str = str + "\ttags: " + StringUtil.indent(this.getTags().toString());
        str = str + "}";
        return str;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeDouble(this.lat);
        out.writeDouble(this.lon);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.lat = in.readDouble();
        this.lon = in.readDouble();
    }
}

