/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.osm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.morbz.osmonaut.geometry.Bounds;
import net.morbz.osmonaut.osm.EntityType;
import net.morbz.osmonaut.osm.LatLon;
import net.morbz.osmonaut.osm.Tags;

public abstract class Entity
implements Externalizable {
    protected long id;
    private Tags tags;

    public Entity(long id, Tags tags) {
        this.id = id;
        if (tags != null && tags.size() > 0) {
            this.tags = tags;
        }
    }

    public Entity() {
    }

    public long getId() {
        return this.id;
    }

    public Tags getTags() {
        if (this.tags == null) {
            return new Tags();
        }
        return this.tags;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)obj;
        if (entity.getEntityType() != this.getEntityType()) {
            return false;
        }
        return entity.getId() == this.id;
    }

    public abstract EntityType getEntityType();

    public abstract LatLon getCenter();

    public abstract Bounds getBounds();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeObject(this.tags);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.tags = (Tags)in.readObject();
    }
}

