/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.binary.pbf;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.morbz.osmonaut.binary.pbf.PbfRawBlob;
import net.morbz.osmonaut.binary.pbf.RawBlobProvider;
import net.morbz.osmonaut.binary.pbf.proto.Fileformat;

public class RawBlobReader
extends RawBlobProvider {
    private boolean eof = false;
    private PbfRawBlob nextBlob;

    public RawBlobReader(RandomAccessFile file) {
        super(file);
    }

    private Fileformat.BlobHeader readHeader(int headerLength) throws IOException {
        byte[] headerBuffer = new byte[headerLength];
        this.file.readFully(headerBuffer);
        Fileformat.BlobHeader blobHeader = Fileformat.BlobHeader.parseFrom(headerBuffer);
        return blobHeader;
    }

    private void getNextBlob() {
        try {
            int headerLength;
            try {
                headerLength = this.file.readInt();
            }
            catch (EOFException e) {
                this.eof = true;
                return;
            }
            Fileformat.BlobHeader blobHeader = this.readHeader(headerLength);
            long fileOffset = this.file.getFilePointer();
            byte[] blobData = this.readRawBlob(blobHeader.getDatasize());
            this.nextBlob = new PbfRawBlob(blobHeader.getType(), blobData, fileOffset);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get next blob from PBF stream.", e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextBlob == null && !this.eof) {
            this.getNextBlob();
        }
        return this.nextBlob != null;
    }

    @Override
    public PbfRawBlob next() {
        PbfRawBlob result = this.nextBlob;
        this.nextBlob = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetIterator() {
    }
}

