/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut.binary.pbf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.morbz.osmonaut.binary.pbf.PbfRawBlob;
import net.morbz.osmonaut.binary.pbf.RawBlobProvider;

public class RawBlobIndexer
extends RawBlobProvider {
    private List<BlobFileIndex> blobIndexes = new ArrayList<BlobFileIndex>();
    private Iterator<BlobFileIndex> iterator;

    public RawBlobIndexer(RandomAccessFile file) {
        super(file);
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.blobIndexes.iterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public PbfRawBlob next() {
        try {
            BlobFileIndex blobIndex = this.iterator.next();
            this.file.seek(blobIndex.getFileOffset());
            byte[] blobData = this.readRawBlob(blobIndex.getBlobSize());
            return new PbfRawBlob("OSMData", blobData, blobIndex.getFileOffset());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get next blob from PBF stream.", e);
        }
    }

    public void indexBlob(long fileOffset, int blobSize) {
        BlobFileIndex blobIndex = new BlobFileIndex(fileOffset, blobSize);
        this.blobIndexes.add(blobIndex);
    }

    @Override
    public void resetIterator() {
        this.iterator = null;
    }

    private class BlobFileIndex {
        private long fileOffset;
        private int blobSize;

        public BlobFileIndex(long fileOffset, int blobSize) {
            this.fileOffset = fileOffset;
            this.blobSize = blobSize;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public int getBlobSize() {
            return this.blobSize;
        }
    }
}

