/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut;

import java.io.File;
import java.util.ArrayList;
import net.morbz.osmonaut.EntityCache;
import net.morbz.osmonaut.EntityFilter;
import net.morbz.osmonaut.IOsmonautReceiver;
import net.morbz.osmonaut.binary.OsmonautSink;
import net.morbz.osmonaut.binary.pbf.PbfDecoder;
import net.morbz.osmonaut.osm.Entity;
import net.morbz.osmonaut.osm.EntityType;
import net.morbz.osmonaut.osm.Node;
import net.morbz.osmonaut.osm.Relation;
import net.morbz.osmonaut.osm.RelationMember;
import net.morbz.osmonaut.osm.Way;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class Osmonaut {
    private EntityCache<Node> nodeCache;
    private EntityCache<Way> wayCache;
    private final File file;
    private final EntityFilter filter;
    private IOsmonautReceiver receiver;
    private PbfDecoder decoder;
    private boolean wayNodeTags = true;
    private int processors;
    private boolean storeOnDisk = false;
    private int verbosity = 1;

    public Osmonaut(String filename, EntityFilter filter) {
        this.file = new File(filename);
        this.filter = filter;
        this.processors = Math.min(4, Runtime.getRuntime().availableProcessors());
    }

    @Deprecated
    public Osmonaut(String filename, EntityFilter filter, boolean wayNodeTags) {
        this(filename, filter);
        this.wayNodeTags = wayNodeTags;
    }

    public void scan(IOsmonautReceiver receiver) {
        this.receiver = receiver;
        this.log("OSMonaut started", 1);
        if (!this.file.exists()) {
            this.log("E: Input file does not exist", 0);
            return;
        }
        boolean somethingNeeded = false;
        for (EntityType type : EntityType.values()) {
            if (!this.filter.getEntityEnabled(type)) continue;
            somethingNeeded = true;
            break;
        }
        if (!somethingNeeded) {
            this.log("Nothing to scan", 1);
            return;
        }
        this.decoder = new PbfDecoder(this.file, this.processors);
        if (this.storeOnDisk) {
            DB db = DBMaker.tempFileDB().closeOnJvmShutdown().fileMmapEnableIfSupported().fileChannelEnable().make();
            this.nodeCache = EntityCache.getDiskEntityCache(db, "node");
            this.wayCache = EntityCache.getDiskEntityCache(db, "way");
        } else {
            this.nodeCache = EntityCache.getMemoryEntityCache();
            this.wayCache = EntityCache.getMemoryEntityCache();
        }
        if (this.filter.getEntityEnabled(EntityType.RELATION)) {
            this.log("Scanning relations...", 1);
            this.scanRelations();
        }
        if (this.filter.getEntityEnabled(EntityType.WAY) || this.wayCache.needsEntities()) {
            this.log("Scanning ways...", 1);
            this.scanWays();
        }
        this.log("Final scan...", 1);
        this.finalScan();
        this.decoder.close();
        this.nodeCache = null;
        this.wayCache = null;
        this.decoder = null;
    }

    private void scanRelations() {
        this.decoder.scan(EntityType.RELATION, new OsmonautSink(){

            @Override
            public void foundEntity(Entity entity) {
                Relation relation = (Relation)entity;
                if (!Osmonaut.this.entityNeededForReceiver(relation)) {
                    return;
                }
                for (RelationMember member : relation.getMembers()) {
                    switch (member.getEntity().getEntityType()) {
                        case NODE: {
                            Osmonaut.this.nodeCache.addNeeded(member.getEntity().getId());
                            break;
                        }
                        case WAY: {
                            Osmonaut.this.wayCache.addNeeded(member.getEntity().getId());
                            break;
                        }
                    }
                }
            }
        });
    }

    private void scanWays() {
        this.decoder.scan(EntityType.WAY, new OsmonautSink(){

            @Override
            public void foundEntity(Entity entity) {
                Way way = (Way)entity;
                if (!Osmonaut.this.entityNeededForReceiver(way) && !Osmonaut.this.wayCache.isNeeded(way.getId())) {
                    return;
                }
                for (Node node : way.getNodes()) {
                    Osmonaut.this.nodeCache.addNeeded(node.getId());
                }
            }
        });
    }

    private void finalScan() {
        if (this.filter.getEntityEnabled(EntityType.NODE) || this.nodeCache.needsEntities()) {
            this.log("...Scanning nodes", 1);
            this.decoder.scan(EntityType.NODE, new OsmonautSink(){

                @Override
                public void foundEntity(Entity entity) {
                    Node node = (Node)entity;
                    if (Osmonaut.this.entityNeededForReceiver(node)) {
                        Osmonaut.this.receiver.foundEntity(node);
                    }
                    if (Osmonaut.this.nodeCache.isNeeded(node.getId())) {
                        if (!Osmonaut.this.wayNodeTags) {
                            node = new Node(node.getId(), null, node.getLatlon());
                        }
                        Osmonaut.this.nodeCache.addEntity(node);
                    }
                }
            });
        }
        if (this.filter.getEntityEnabled(EntityType.WAY) || this.wayCache.needsEntities()) {
            this.log("...Scanning ways", 1);
            this.decoder.scan(EntityType.WAY, new OsmonautSink(){

                @Override
                public void foundEntity(Entity entity) {
                    Way way = (Way)entity;
                    if (!Osmonaut.this.entityNeededForReceiver(way) && !Osmonaut.this.wayCache.isNeeded(way.getId())) {
                        return;
                    }
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    for (Node incompleteNode : way.getNodes()) {
                        Node node = (Node)Osmonaut.this.nodeCache.getEntity(incompleteNode.getId());
                        if (node == null) {
                            Osmonaut.this.log("E: Node for way not found", 0);
                            continue;
                        }
                        nodes.add(node);
                    }
                    Way newWay = new Way(way.getId(), way.getTags(), nodes);
                    if (Osmonaut.this.entityNeededForReceiver(way)) {
                        Osmonaut.this.receiver.foundEntity(newWay);
                    }
                    if (Osmonaut.this.wayCache.isNeeded(way.getId())) {
                        Osmonaut.this.wayCache.addEntity(newWay);
                    }
                }
            });
        }
        if (this.filter.getEntityEnabled(EntityType.RELATION)) {
            this.log("...Scanning relations", 1);
            this.decoder.scan(EntityType.RELATION, new OsmonautSink(){

                @Override
                public void foundEntity(Entity entity) {
                    Relation relation = (Relation)entity;
                    if (!Osmonaut.this.entityNeededForReceiver(relation)) {
                        return;
                    }
                    boolean incomplete = relation.isIncomplete();
                    ArrayList<RelationMember> members = new ArrayList<RelationMember>();
                    for (RelationMember member : relation.getMembers()) {
                        long id = member.getEntity().getId();
                        Entity memberEntity = null;
                        switch (member.getEntity().getEntityType()) {
                            case NODE: {
                                memberEntity = (Entity)Osmonaut.this.nodeCache.getEntity(id);
                                break;
                            }
                            case WAY: {
                                memberEntity = (Entity)Osmonaut.this.wayCache.getEntity(id);
                                break;
                            }
                        }
                        if (memberEntity == null) {
                            incomplete = true;
                            continue;
                        }
                        members.add(new RelationMember(memberEntity, member.getRole()));
                    }
                    Relation newRelation = new Relation(relation.getId(), relation.getTags(), members, incomplete);
                    Osmonaut.this.receiver.foundEntity(newRelation);
                }
            });
        }
    }

    private boolean entityNeededForReceiver(Entity entity) {
        EntityType type = entity.getEntityType();
        if (!this.filter.getEntityEnabled(type)) {
            return false;
        }
        return this.receiver.needsEntity(type, entity.getTags());
    }

    private void log(String msg, int verbosity) {
        if (this.verbosity >= verbosity) {
            System.out.println(msg);
        }
    }

    public void setWayNodeTags(boolean wayNodeTags) {
        this.wayNodeTags = wayNodeTags;
    }

    public void setProcessors(int processors) {
        this.processors = processors;
    }

    public void setStoreOnDisk(boolean storeOnDisk) {
        this.storeOnDisk = storeOnDisk;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }
}

