/*
 * Decompiled with CFR 0.152.
 */
package net.morbz.osmonaut;

import net.morbz.osmonaut.DiskEntityMap;
import net.morbz.osmonaut.EntityMap;
import net.morbz.osmonaut.IdTracker;
import net.morbz.osmonaut.MemoryEntityMap;
import net.morbz.osmonaut.osm.Entity;
import org.mapdb.DB;

public class EntityCache<T extends Entity> {
    private IdTracker idTracker = new IdTracker();
    private EntityMap<T> entityMap;

    public EntityCache(EntityMap<T> entityMap) {
        this.entityMap = entityMap;
    }

    public static <T extends Entity> EntityCache<T> getMemoryEntityCache() {
        MemoryEntityMap entityMap = new MemoryEntityMap();
        return new EntityCache(entityMap);
    }

    public static <T extends Entity> EntityCache<T> getDiskEntityCache(DB db, String name) {
        DiskEntityMap entityMap = new DiskEntityMap(db, name);
        return new EntityCache(entityMap);
    }

    public void addNeeded(long id) {
        this.idTracker.set(id);
    }

    public boolean isNeeded(Long id) {
        return this.idTracker.get(id);
    }

    public void addEntity(T entity) {
        this.idTracker.unset(((Entity)entity).getId());
        this.entityMap.add(entity);
    }

    public T getEntity(long id) {
        return this.entityMap.get(id);
    }

    public boolean needsEntities() {
        return !this.idTracker.isEmpty();
    }
}

