/*
 * Decompiled with CFR 0.152.
 */
package com.whiteelephant.monthpicker;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.example.prem.firstpitch.R;
import com.whiteelephant.monthpicker.MonthView;
import java.util.HashMap;

class MonthViewAdapter
extends BaseAdapter {
    private int _minMonth;
    private int _maxMonth;
    private int _activatedMonth;
    private Context _context;
    private HashMap<String, Integer> _colors;
    private OnDaySelectedListener mOnDaySelectedListener;
    private final MonthView.OnMonthClickListener mOnDayClickListener = new MonthView.OnMonthClickListener(){

        @Override
        public void onMonthClick(MonthView view, int day) {
            Log.d((String)"MonthViewAdapter", (String)("onDayClick " + day));
            if (MonthViewAdapter.this.isCalendarInRange(day)) {
                Log.d((String)"MonthViewAdapter", (String)("day not null && Calender in range " + day));
                MonthViewAdapter.this.setSelectedMonth(day);
                if (MonthViewAdapter.this.mOnDaySelectedListener != null) {
                    MonthViewAdapter.this.mOnDaySelectedListener.onDaySelected(MonthViewAdapter.this, day);
                }
            }
        }
    };

    public MonthViewAdapter(Context context) {
        this._context = context;
        this.setRange();
    }

    public int getCount() {
        return 1;
    }

    public Object getItem(int i) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup viewGroup) {
        MonthView v;
        if (convertView != null) {
            v = (MonthView)convertView;
        } else {
            v = new MonthView(this._context);
            v.setColors(this._colors);
            AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
            v.setLayoutParams((ViewGroup.LayoutParams)params);
            v.setClickable(true);
            v.setOnMonthClickListener(this.mOnDayClickListener);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            v.setBackgroundDrawable(this._context.getDrawable(R.drawable.month_ripplr));
        }
        v.setMonthParams(this._activatedMonth, this._minMonth, this._maxMonth);
        v.reuse();
        v.invalidate();
        return v;
    }

    boolean isCalendarInRange(int value) {
        return value >= this._minMonth && value <= this._maxMonth;
    }

    public void setSelectedMonth(int month) {
        Log.d((String)"MonthViewAdapter", (String)("setSelectedMonth : " + month));
        this._activatedMonth = month;
        this.notifyDataSetChanged();
    }

    public void setRange() {
        this._minMonth = 0;
        this._maxMonth = 11;
        this._activatedMonth = 7;
        this.notifyDataSetInvalidated();
    }

    public void setOnDaySelectedListener(OnDaySelectedListener listener) {
        this.mOnDaySelectedListener = listener;
    }

    void setMaxMonth(int maxMonth) {
        if (maxMonth > 11 || maxMonth < 0) {
            throw new IllegalArgumentException("Month out of range please send months between Calendar.JANUARY, Calendar.DECEMBER");
        }
        this._maxMonth = maxMonth;
    }

    void setMinMonth(int minMonth) {
        if (minMonth < 0 || minMonth > 11) {
            throw new IllegalArgumentException("Month out of range please send months between Calendar.JANUARY, Calendar.DECEMBER");
        }
        this._minMonth = minMonth;
    }

    void setActivatedMonth(int activatedMonth) {
        if (activatedMonth < 0 || activatedMonth > 11) {
            throw new IllegalArgumentException("Month out of range please send months between Calendar.JANUARY, Calendar.DECEMBER");
        }
        this._activatedMonth = activatedMonth;
    }

    void setColors(HashMap map) {
        this._colors = map;
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(MonthViewAdapter var1, int var2);
    }
}

