/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.Memory;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.posix.util.WindowsHelpers;

public final class WString {
    static final Runtime runtime = Runtime.getSystemRuntime();
    private final byte[] bytes;
    public static final ToNativeConverter<WString, Pointer> Converter = new ToNativeConverter<WString, Pointer>(){

        public Pointer toNative(WString value, ToNativeContext context) {
            if (value == null) {
                return null;
            }
            Pointer memory = Memory.allocateDirect((Runtime)runtime, (int)(value.bytes.length + 1), (boolean)true);
            memory.put(0L, value.bytes, 0, value.bytes.length);
            return memory;
        }

        public Class<Pointer> nativeType() {
            return Pointer.class;
        }
    };

    WString(String string) {
        this.bytes = WindowsHelpers.toWString(string);
    }

    private WString(byte[] bytes) {
        this.bytes = bytes;
    }

    public static WString path(String path) {
        return WString.path(path, false);
    }

    public static WString path(String path, boolean longPathExtensionNeeded) {
        if (longPathExtensionNeeded && path.length() > 240) {
            if (path.startsWith("//")) {
                path = "//?/UNC/" + path.substring(2);
            } else if (path.startsWith("\\\\")) {
                path = "\\\\?\\UNC\\" + path.substring(2);
            } else if (WindowsHelpers.isDriveLetterPath(path)) {
                path = path.contains("/") ? "//?/" + path : "\\\\?\\" + path;
            }
        }
        return new WString(WindowsHelpers.toWPath(path));
    }
}

