/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jnr.ffi.ObjectReferenceManager;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.InAccessibleMemoryIO;

public final class DefaultObjectReferenceManager
extends ObjectReferenceManager {
    private final Runtime runtime;
    private final ConcurrentMap<Pointer, Object> references = new ConcurrentHashMap<Pointer, Object>();

    public DefaultObjectReferenceManager(Runtime runtime) {
        this.runtime = runtime;
    }

    public Pointer newReference(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("reference to null value not allowed");
        }
        int nextId = System.identityHashCode(obj);
        ObjectReference ptr = null;
        while (this.references.putIfAbsent(ptr = new ObjectReference(this.runtime, nextId), obj) != null) {
            ++nextId;
        }
        return ptr;
    }

    public void freeReference(Pointer reference) {
        this.references.remove(reference);
    }

    public Object getObject(Pointer reference) {
        return this.references.get(reference);
    }

    private static final class ObjectReference
    extends InAccessibleMemoryIO {
        private final int address;

        public ObjectReference(Runtime runtime, int address) {
            super(runtime);
            this.address = address;
        }

        public boolean isDirect() {
            return true;
        }

        public long address() {
            return (long)this.address & 0xFFFFFFFFL;
        }

        public long size() {
            return 0L;
        }

        public int hashCode() {
            return this.address;
        }

        public boolean equals(Object obj) {
            return obj.getClass() == ObjectReference.class && ((ObjectReference)obj).address == this.address;
        }
    }
}

