/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.Address;
import jnr.ffi.LibraryOption;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.annotations.StdCall;
import jnr.ffi.byref.ByReference;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.FunctionMapper;
import jnr.ffi.mapper.MethodParameterContext;
import jnr.ffi.mapper.MethodResultContext;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.IdentityFunctionMapper;
import jnr.ffi.provider.NullTypeMapper;
import jnr.ffi.provider.jffi.AbstractAsmLibraryInterface;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.AsmClassLoader;
import jnr.ffi.provider.jffi.AsmRuntime;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.FastIntMethodGenerator;
import jnr.ffi.provider.jffi.FastLongMethodGenerator;
import jnr.ffi.provider.jffi.FastNumericMethodGenerator;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.LibraryLoader;
import jnr.ffi.provider.jffi.MethodGenerator;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.NativeLibrary;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterConverter;
import jnr.ffi.provider.jffi.ResultConverter;
import jnr.ffi.provider.jffi.Signature;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import jnr.ffi.provider.jffi.StubCompiler;
import jnr.ffi.provider.jffi.SymbolNotFoundError;
import jnr.ffi.provider.jffi.X86MethodGenerator;
import jnr.ffi.util.EnumMapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmLibraryLoader
extends LibraryLoader {
    public static final boolean DEBUG = Boolean.getBoolean("jnr.ffi.compile.dump");
    private static final AtomicLong nextClassID = new AtomicLong(0L);
    private final AtomicLong nextIvarID = new AtomicLong(0L);
    private final AtomicLong nextMethodID = new AtomicLong(0L);
    private final NativeClosureManager closureManager = NativeRuntime.getInstance().getClosureManager();

    @Override
    boolean isInterfaceSupported(Class interfaceClass, Map<LibraryOption, ?> options) {
        TypeMapper typeMapper = options.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)options.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        for (Method m : interfaceClass.getDeclaredMethods()) {
            if (!AsmLibraryLoader.isReturnTypeSupported(m.getReturnType()) && this.getResultConverter(m, typeMapper) == null) {
                System.err.println("Unsupported return type: " + m.getReturnType());
                return false;
            }
            for (Class<?> c : m.getParameterTypes()) {
                if (AsmLibraryLoader.isParameterTypeSupported(c) || typeMapper.getToNativeConverter(c) != null) continue;
                System.err.println("Unsupported parameter type: " + c);
                return false;
            }
        }
        return true;
    }

    @Override
    <T> T loadLibrary(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        return this.generateInterfaceImpl(library, interfaceClass, libraryOptions);
    }

    private final <T> T generateInterfaceImpl(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        ClassWriter cw = new ClassWriter(2);
        ClassWriter cv = DEBUG ? AsmUtil.newCheckClassAdapter((ClassVisitor)cw) : cw;
        String className = CodegenUtils.p(interfaceClass) + "$jaffl$" + nextClassID.getAndIncrement();
        AsmBuilder builder = new AsmBuilder(className, (ClassVisitor)cv);
        cv.visit(49, 17, className, null, CodegenUtils.p(AbstractAsmLibraryInterface.class), new String[]{CodegenUtils.p(interfaceClass)});
        SkinnyMethodAdapter init = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, NativeLibrary.class, Function[].class, FromNativeConverter[].class, ToNativeConverter[].class), null, null));
        init.start();
        init.aload(0);
        init.aload(1);
        init.invokespecial(CodegenUtils.p(AbstractAsmLibraryInterface.class), "<init>", CodegenUtils.sig(Void.TYPE, NativeLibrary.class));
        Method[] methods = interfaceClass.getMethods();
        Function[] functions = new Function[methods.length];
        FromNativeConverter[] resultConverters = new FromNativeConverter[methods.length];
        ToNativeConverter[][] parameterConverters = new ToNativeConverter[methods.length][0];
        FunctionMapper functionMapper = libraryOptions.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)libraryOptions.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.getInstance();
        TypeMapper typeMapper = libraryOptions.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)libraryOptions.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        CallingConvention libraryCallingConvention = AsmLibraryLoader.getCallingConvention(interfaceClass, libraryOptions);
        BufferMethodGenerator bufgen = new BufferMethodGenerator();
        StubCompiler compiler = StubCompiler.newCompiler();
        MethodGenerator[] generators = new MethodGenerator[]{new X86MethodGenerator(compiler, bufgen), new FastIntMethodGenerator(bufgen), new FastLongMethodGenerator(bufgen), new FastNumericMethodGenerator(bufgen), bufgen};
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            Class<?> returnType = m.getReturnType();
            Class[] parameterTypes = m.getParameterTypes();
            Class<Object> nativeReturnType = returnType;
            Class[] nativeParameterTypes = new Class[parameterTypes.length];
            Annotation[] resultAnnotations = m.getAnnotations();
            Annotation[][] parameterAnnotations = m.getParameterAnnotations();
            boolean conversionRequired = false;
            resultConverters[i] = this.getResultConverter(m, typeMapper);
            if (resultConverters[i] != null) {
                nativeReturnType = resultConverters[i].nativeType();
                conversionRequired = true;
            }
            parameterConverters[i] = new ToNativeConverter[parameterTypes.length];
            for (int pidx = 0; pidx < parameterTypes.length; ++pidx) {
                ToNativeConverter converter = this.getParameterConverter(m, pidx, typeMapper);
                if (converter != null) {
                    nativeParameterTypes[pidx] = converter.nativeType();
                    parameterConverters[i][pidx] = new ParameterConverter(converter, new MethodParameterContext(m, pidx));
                    conversionRequired = true;
                    continue;
                }
                nativeParameterTypes[pidx] = NumberUtil.isLong32(parameterTypes[pidx], parameterAnnotations[pidx]) ? (parameterTypes[pidx] == Long.TYPE ? Integer.TYPE : Integer.class) : parameterTypes[pidx];
            }
            String functionName = functionMapper.mapFunctionName(m.getName(), null);
            cv.visitField(26, "name_" + i, CodegenUtils.ci(String.class), null, (Object)functionName);
            CallingConvention callingConvention = m.getAnnotation(StdCall.class) != null ? CallingConvention.STDCALL : libraryCallingConvention;
            try {
                functions[i] = AsmLibraryLoader.getFunction(library.findSymbolAddress(functionName), nativeReturnType, resultAnnotations, nativeParameterTypes, parameterAnnotations, InvokerUtil.requiresErrno(m), callingConvention);
            }
            catch (SymbolNotFoundError ex) {
                cv.visitField(26, "error_" + i, CodegenUtils.ci(String.class), null, (Object)ex.getMessage());
                this.generateFunctionNotFound((ClassVisitor)cv, className, i, functionName, returnType, parameterTypes);
                continue;
            }
            String functionFieldName = "function_" + i;
            builder.addFunctionField(functions[i], functionFieldName);
            cv.visitField(18, functionFieldName, CodegenUtils.ci(Function.class), null, null);
            Signature signature = new Signature(nativeReturnType, nativeParameterTypes, resultAnnotations, parameterAnnotations, callingConvention, !InvokerUtil.requiresErrno(m));
            String rawMethodName = m.getName() + (conversionRequired ? "$raw" + this.nextMethodID.incrementAndGet() : "");
            for (MethodGenerator g : generators) {
                if (!g.isSupported(signature)) continue;
                g.generate(builder, rawMethodName, functions[i], signature);
                break;
            }
            if (conversionRequired) {
                this.generateConversionMethod(builder, m.getName(), rawMethodName, i, returnType, parameterTypes, nativeReturnType, nativeParameterTypes, resultConverters[i], parameterConverters[i]);
            }
            init.aload(0);
            init.aload(2);
            init.pushInt(i);
            init.aaload();
            init.putfield(className, functionFieldName, CodegenUtils.ci(Function.class));
        }
        FromNativeConverter[] fromNativeConverters = builder.getFromNativeConverterArray();
        for (int i = 0; i < fromNativeConverters.length; ++i) {
            String fieldName = builder.getResultConverterName(fromNativeConverters[i]);
            cv.visitField(18, fieldName, CodegenUtils.ci(FromNativeConverter.class), null, null);
            init.aload(0);
            init.aload(3);
            init.pushInt(i);
            init.aaload();
            init.putfield(className, fieldName, CodegenUtils.ci(FromNativeConverter.class));
        }
        ToNativeConverter[] toNativeConverters = builder.getToNativeConverterArray();
        for (int i = 0; i < toNativeConverters.length; ++i) {
            String fieldName = builder.getParameterConverterName(toNativeConverters[i]);
            cv.visitField(18, fieldName, CodegenUtils.ci(ToNativeConverter.class), null, null);
            init.aload(0);
            init.aload(4);
            init.pushInt(i);
            init.aaload();
            init.putfield(className, fieldName, CodegenUtils.ci(ToNativeConverter.class));
        }
        init.voidreturn();
        init.visitMaxs(10, 10);
        init.visitEnd();
        cv.visitEnd();
        try {
            byte[] bytes = cw.toByteArray();
            if (DEBUG) {
                ClassVisitor trace = AsmUtil.newTraceClassVisitor(new PrintWriter(System.err));
                new ClassReader(bytes).accept(trace, 0);
            }
            Class implClass = new AsmClassLoader(interfaceClass.getClassLoader()).defineClass(className.replace("/", "."), bytes);
            Constructor cons = implClass.getDeclaredConstructor(NativeLibrary.class, Function[].class, FromNativeConverter[].class, ToNativeConverter[].class);
            Object result = cons.newInstance(library, functions, fromNativeConverters, toNativeConverters);
            compiler.attach(implClass);
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private final ToNativeConverter getParameterConverter(Method m, int parameterIndex, TypeMapper typeMapper) {
        Class<?> parameterType = m.getParameterTypes()[parameterIndex];
        ToNativeConverter conv = typeMapper.getToNativeConverter(parameterType);
        if (conv != null) {
            return new ParameterConverter(conv, new MethodParameterContext(m, parameterIndex));
        }
        if (Enum.class.isAssignableFrom(parameterType)) {
            return EnumMapper.getInstance(parameterType.asSubclass(Enum.class));
        }
        if (AsmUtil.isDelegate(parameterType)) {
            return this.closureManager.getClosureFactory(parameterType);
        }
        return null;
    }

    private final FromNativeConverter getResultConverter(Method m, TypeMapper typeMapper) {
        Class<?> returnType = m.getReturnType();
        FromNativeConverter conv = typeMapper.getFromNativeConverter(returnType);
        if (conv != null) {
            return new ResultConverter(conv, new MethodResultContext(m));
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            return EnumMapper.getInstance(returnType.asSubclass(Enum.class));
        }
        return null;
    }

    private static final CallingConvention getCallingConvention(Class interfaceClass, Map<LibraryOption, ?> options) {
        if (interfaceClass.getAnnotation(StdCall.class) != null) {
            return CallingConvention.STDCALL;
        }
        return InvokerUtil.getCallingConvention(options);
    }

    private final void generateFunctionNotFound(ClassVisitor cv, String className, int idx, String functionName, Class returnType, Class[] parameterTypes) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        mv.getstatic(className, "error_" + idx, CodegenUtils.ci(String.class));
        mv.invokestatic(AsmRuntime.class, "newUnsatisifiedLinkError", UnsatisfiedLinkError.class, String.class);
        mv.athrow();
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    private final void generateConversionMethod(AsmBuilder builder, String functionName, String rawFunctionName, int idx, Class returnType, Class[] parameterTypes, Class nativeReturnType, Class[] nativeParameterTypes, FromNativeConverter resultConverter, ToNativeConverter[] parameterConverters) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(builder.getClassVisitor().visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        if (!returnType.equals(nativeReturnType)) {
            mv.aload(0);
            mv.getfield(builder.getClassNamePath(), builder.getResultConverterName(resultConverter), CodegenUtils.ci(FromNativeConverter.class));
        }
        mv.aload(0);
        int lvar = 1;
        for (int pidx = 0; pidx < parameterTypes.length; ++pidx) {
            boolean convertLong;
            boolean convertParameter = !parameterTypes[pidx].equals(nativeParameterTypes[pidx]);
            boolean bl = convertLong = Long.TYPE == parameterTypes[pidx] && Integer.TYPE == nativeParameterTypes[pidx];
            if (convertParameter && !convertLong) {
                mv.aload(0);
                mv.getfield(builder.getClassNamePath(), builder.getParameterConverterName(parameterConverters[pidx]), CodegenUtils.ci(ToNativeConverter.class));
            }
            lvar = AsmLibraryLoader.loadParameter(mv, parameterTypes[pidx], lvar);
            if (convertParameter && convertLong) {
                mv.l2i();
                continue;
            }
            if (!convertParameter) continue;
            if (parameterTypes[pidx].isPrimitive()) {
                AsmUtil.boxValue(mv, NumberUtil.getBoxedClass(parameterTypes[pidx]), parameterTypes[pidx]);
            }
            mv.aconst_null();
            mv.invokeinterface(ToNativeConverter.class, "toNative", Object.class, Object.class, ToNativeContext.class);
            mv.checkcast(CodegenUtils.p(nativeParameterTypes[pidx]));
        }
        mv.invokevirtual(builder.getClassNamePath(), rawFunctionName, CodegenUtils.sig(nativeReturnType, nativeParameterTypes));
        if (!returnType.equals(nativeReturnType)) {
            if (nativeReturnType.isPrimitive()) {
                AsmUtil.boxValue(mv, NumberUtil.getBoxedClass(nativeReturnType), nativeReturnType);
            }
            mv.aconst_null();
            mv.invokeinterface(FromNativeConverter.class, "fromNative", Object.class, Object.class, FromNativeContext.class);
            mv.checkcast(CodegenUtils.p(returnType));
        }
        AsmUtil.emitReturnOp(mv, returnType);
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    static final Label emitDirectCheck(SkinnyMethodAdapter mv, Class[] parameterTypes) {
        Label bufferInvocationLabel = new Label();
        boolean needBufferInvocation = false;
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (Pointer.class.isAssignableFrom(parameterTypes[i])) {
                mv.aload(lvar++);
                mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Pointer.class);
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            if (Struct.class.isAssignableFrom(parameterTypes[i])) {
                mv.aload(lvar++);
                mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Struct.class);
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            if (Buffer.class.isAssignableFrom(parameterTypes[i])) {
                mv.aload(lvar++);
                if (Platform.getPlatform().getJavaMajorVersion() < 6 && Buffer.class == parameterTypes[i]) {
                    mv.invokestatic(AsmRuntime.class, "isDirect5", Boolean.TYPE, Buffer.class);
                } else {
                    mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, parameterTypes[i]);
                }
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            lvar += AsmUtil.calculateLocalVariableSpace(parameterTypes[i]);
        }
        return needBufferInvocation ? bufferInvocationLabel : null;
    }

    static final void emitReturn(SkinnyMethodAdapter mv, Class returnType, Class nativeIntType) {
        if (returnType.isPrimitive()) {
            if (Long.TYPE == returnType) {
                NumberUtil.widen(mv, nativeIntType, returnType);
                mv.lreturn();
            } else if (Float.TYPE == returnType) {
                mv.freturn();
            } else if (Double.TYPE == returnType) {
                mv.dreturn();
            } else if (Void.TYPE == returnType) {
                mv.voidreturn();
            } else {
                NumberUtil.narrow(mv, nativeIntType, returnType);
                mv.ireturn();
            }
        } else {
            AsmUtil.boxValue(mv, returnType, nativeIntType);
            mv.areturn();
        }
    }

    static int loadParameter(SkinnyMethodAdapter mv, Class parameterType, int lvar) {
        if (!parameterType.isPrimitive()) {
            mv.aload(lvar++);
        } else if (Long.TYPE == parameterType) {
            mv.lload(lvar);
            lvar += 2;
        } else if (Float.TYPE == parameterType) {
            mv.fload(lvar++);
        } else if (Double.TYPE == parameterType) {
            mv.dload(lvar);
            lvar += 2;
        } else {
            mv.iload(lvar++);
        }
        return lvar;
    }

    private static final Function getFunction(long address, Class resultType, Annotation[] resultAnnotations, Class[] parameterTypes, Annotation[][] parameterAnnotations, boolean requiresErrno, CallingConvention convention) {
        Type[] nativeParamTypes = new Type[parameterTypes.length];
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            nativeParamTypes[i] = InvokerUtil.getNativeParameterType(parameterTypes[i], parameterAnnotations[i]);
        }
        return new Function(address, InvokerUtil.getNativeReturnType(resultType, resultAnnotations), nativeParamTypes, convention, requiresErrno);
    }

    private static boolean isReturnTypeSupported(Class type) {
        return type.isPrimitive() || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type || NativeLong.class == type || Enum.class.isAssignableFrom(type) || Pointer.class == type || Address.class == type || String.class == type || Struct.class.isAssignableFrom(type);
    }

    private static boolean isParameterTypeSupported(Class type) {
        return type.isPrimitive() || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type || NativeLong.class == type || Pointer.class.isAssignableFrom(type) || Address.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || Buffer.class.isAssignableFrom(type) || type.isArray() && type.getComponentType().isPrimitive() || Struct.class.isAssignableFrom(type) || type.isArray() && Struct.class.isAssignableFrom(type.getComponentType()) || type.isArray() && Pointer.class.isAssignableFrom(type.getComponentType()) || type.isArray() && CharSequence.class.isAssignableFrom(type.getComponentType()) || CharSequence.class.isAssignableFrom(type) || ByReference.class.isAssignableFrom(type) || StringBuilder.class.isAssignableFrom(type) || StringBuffer.class.isAssignableFrom(type) || AsmUtil.isDelegate(type);
    }
}

