/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import jnr.ffi.NativeType;
import jnr.ffi.Runtime;
import jnr.ffi.Type;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.util.EnumMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Struct {
    static final Charset ASCII = Charset.forName("ASCII");
    static final Charset UTF8 = Charset.forName("UTF-8");
    final Info __info;

    protected Struct(Runtime runtime) {
        this.__info = new Info(runtime);
    }

    Struct(Runtime runtime, boolean isUnion) {
        this(runtime);
        this.__info.resetIndex = isUnion;
    }

    public final Runtime getRuntime() {
        return this.__info.runtime;
    }

    public final void useMemory(jnr.ffi.Pointer address) {
        this.__info.useMemory(address);
    }

    public static jnr.ffi.Pointer getMemory(Struct struct) {
        return struct.__info.getMemory(0);
    }

    public static jnr.ffi.Pointer getMemory(Struct struct, int flags) {
        return struct.__info.getMemory(flags);
    }

    public static int size(Struct struct) {
        return struct.__info.size();
    }

    public static int alignment(Struct struct) {
        return struct.__info.getMinimumAlignment();
    }

    public static boolean isDirect(Struct struct) {
        return struct.__info.isDirect();
    }

    public static <T extends Struct> T[] arrayOf(Runtime runtime, Class<T> type, int length) {
        try {
            Struct[] array = (Struct[])Array.newInstance(type, length);
            for (int i = 0; i < length; ++i) {
                array[i] = (Struct)type.newInstance();
            }
            if (array.length > 0) {
                int align = Struct.alignment(array[0]);
                int structSize = align + (Struct.size(array[0]) - 1 & ~(align - 1));
                jnr.ffi.Pointer memory = runtime.getMemoryManager().allocateDirect(structSize * length);
                for (int i = 0; i < array.length; ++i) {
                    array[i].useMemory(memory.slice(structSize * i, structSize));
                }
            }
            return array;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public java.lang.String toString() {
        StringBuilder sb = new StringBuilder();
        Field[] fields = this.getClass().getDeclaredFields();
        sb.append(this.getClass().getSimpleName()).append(" { \n");
        java.lang.String fieldPrefix = "    ";
        for (Field field : fields) {
            try {
                sb.append("    ");
                sb.append(field.getName()).append(" = ");
                sb.append(field.get(this).toString());
                sb.append("\n");
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    protected final void arrayBegin() {
        this.__info.resetIndex = false;
    }

    protected final void arrayEnd() {
        this.__info.resetIndex = this.__info.isUnion;
    }

    protected <T extends Member> T[] array(T[] array) {
        this.arrayBegin();
        try {
            Class<?> arrayClass = array.getClass().getComponentType();
            Constructor<?> ctor = arrayClass.getDeclaredConstructor(arrayClass.getEnclosingClass());
            Object[] parameters = new Object[]{this};
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Member)ctor.newInstance(parameters);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed8[] array(Signed8[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed8();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned8[] array(Unsigned8[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned8();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed16[] array(Signed16[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed16();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned16[] array(Unsigned16[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned16();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed32[] array(Signed32[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed32();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned32[] array(Unsigned32[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned32();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed64[] array(Signed64[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed64();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned64[] array(Unsigned64[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned64();
        }
        this.arrayEnd();
        return array;
    }

    protected final SignedLong[] array(SignedLong[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new SignedLong();
        }
        this.arrayEnd();
        return array;
    }

    protected final UnsignedLong[] array(UnsignedLong[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new UnsignedLong();
        }
        this.arrayEnd();
        return array;
    }

    protected final Float[] array(Float[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Float();
        }
        this.arrayEnd();
        return array;
    }

    protected final Double[] array(Double[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Double();
        }
        this.arrayEnd();
        return array;
    }

    protected final Address[] array(Address[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Address();
        }
        this.arrayEnd();
        return array;
    }

    protected final Pointer[] array(Pointer[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Pointer();
        }
        this.arrayEnd();
        return array;
    }

    protected final <T extends Struct> T inner(Struct struct) {
        int salign = struct.__info.getMinimumAlignment();
        int off = salign + (this.__info.size - 1 & ~(salign - 1));
        struct.__info.enclosing = this;
        struct.__info.offset = off;
        this.__info.size = off + struct.__info.size;
        return (T)struct;
    }

    protected final class Padding
    extends AbstractMember {
        public Padding(Type type, int length) {
            super(type.size() * 8 * length, type.alignment() * 8);
        }

        public Padding(NativeType type, int length) {
            super(Struct.this.getRuntime().findType(type).size() * 8 * length, Struct.this.getRuntime().findType(type).alignment() * 8);
        }
    }

    public class AsciiStringRef
    extends UTFStringRef {
        public AsciiStringRef(int size) {
            super(size, ASCII);
        }

        public AsciiStringRef() {
            super(Integer.MAX_VALUE, ASCII);
        }
    }

    public class UTF8StringRef
    extends UTFStringRef {
        public UTF8StringRef(int size) {
            super(size, UTF8);
        }

        public UTF8StringRef() {
            super(Integer.MAX_VALUE, UTF8);
        }
    }

    public class UTFStringRef
    extends String {
        private jnr.ffi.Pointer valueHolder;

        public UTFStringRef(int length, Charset cs) {
            super(Struct.this.getRuntime().findType(NativeType.ADDRESS).size() * 8, Struct.this.getRuntime().findType(NativeType.ADDRESS).alignment() * 8, length, cs);
        }

        public UTFStringRef(Charset cs) {
            this(Integer.MAX_VALUE, cs);
        }

        protected jnr.ffi.Pointer getStringMemory() {
            return this.getMemory().getPointer(this.offset(), this.length());
        }

        public final java.lang.String get() {
            jnr.ffi.Pointer ptr = this.getStringMemory();
            return ptr != null ? ptr.getString(0L, this.length, this.charset) : null;
        }

        public final void set(java.lang.String value) {
            if (value != null) {
                this.valueHolder = Struct.this.getRuntime().getMemoryManager().allocateDirect(this.length() * 4);
                this.valueHolder.putString(0L, value, this.length() * 4, this.charset);
                this.getMemory().putPointer(this.offset(), this.valueHolder);
            } else {
                this.valueHolder = null;
                this.getMemory().putAddress(this.offset(), 0L);
            }
        }
    }

    public class AsciiString
    extends UTFString {
        public AsciiString(int size) {
            super(size, ASCII);
        }
    }

    public class UTF8String
    extends UTFString {
        public UTF8String(int size) {
            super(size, UTF8);
        }
    }

    public class UTFString
    extends String {
        public UTFString(int length, Charset cs) {
            super(length * 8, 8, length, cs);
        }

        protected jnr.ffi.Pointer getStringMemory() {
            return this.getMemory().slice(this.offset(), this.length());
        }

        public final java.lang.String get() {
            return this.getStringMemory().getString(0L, this.length, this.charset);
        }

        public final void set(java.lang.String value) {
            this.getStringMemory().putString(0L, value, this.length, this.charset);
        }
    }

    public abstract class String
    extends AbstractMember {
        protected final Charset charset;
        protected final int length;

        protected String(int size, int align, int length, Charset cs) {
            super(size, align);
            this.length = length;
            this.charset = cs;
        }

        protected String(int size, int align, Offset offset, int length, Charset cs) {
            super(size, align, offset);
            this.length = length;
            this.charset = cs;
        }

        public final int length() {
            return this.length;
        }

        protected abstract jnr.ffi.Pointer getStringMemory();

        public abstract java.lang.String get();

        public abstract void set(java.lang.String var1);

        public final java.lang.String toString() {
            return this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum<T extends java.lang.Enum<T>>
    extends Enum32<T> {
        public Enum(Class<T> enumClass) {
            super(enumClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumLong<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public EnumLong(Class<E> enumClass) {
            super(NativeType.SLONG, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putNativeLong(this.offset(), EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putNativeLong(this.offset(), value.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemory().getNativeLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum64<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum64(Class<E> enumClass) {
            super(NativeType.SLONGLONG, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putLong(this.offset(), EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putLong(this.offset(), value.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemory().getLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum32<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum32(Class<E> enumClass) {
            super(NativeType.SINT, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putInt(this.offset(), EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putInt(this.offset(), value.intValue());
        }

        @Override
        public final int intValue() {
            return this.getMemory().getInt(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum16<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum16(Class<E> enumClass) {
            super(NativeType.SSHORT, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putShort(this.offset(), (short)EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putShort(this.offset(), value.shortValue());
        }

        @Override
        public final int intValue() {
            return this.getMemory().getShort(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum8<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum8(Class<E> enumClass) {
            super(NativeType.SCHAR, enumClass);
        }

        @Override
        public final E get() {
            return (E)((java.lang.Enum)this.enumClass.cast(EnumMapper.getInstance(this.enumClass).valueOf(this.intValue())));
        }

        public final void set(E value) {
            this.getMemory().putByte(this.offset(), (byte)EnumMapper.getInstance(this.enumClass).intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemory().putByte(this.offset(), value.byteValue());
        }

        @Override
        public final int intValue() {
            return this.getMemory().getByte(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class EnumField<E>
    extends NumberField {
        protected final Class<E> enumClass;

        public EnumField(NativeType type, Class<E> enumClass) {
            super(type);
            this.enumClass = enumClass;
        }

        public abstract E get();

        @Override
        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Pointer
    extends NumberField {
        public Pointer() {
            super(NativeType.ADDRESS);
        }

        public Pointer(Offset offset) {
            super(NativeType.ADDRESS, offset);
        }

        public final jnr.ffi.Pointer get() {
            return this.getMemory().getPointer(this.offset());
        }

        public final int size() {
            return Struct.this.getRuntime().findType(NativeType.ADDRESS).size() * 8;
        }

        public final void set(jnr.ffi.Pointer value) {
            this.getMemory().putPointer(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putAddress(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.getMemory().getAddress(this.offset());
        }

        public final long longValue() {
            return this.getMemory().getAddress(this.offset());
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Address
    extends NumberField {
        public Address() {
            super(NativeType.ADDRESS);
        }

        public Address(Offset offset) {
            super(NativeType.ADDRESS, offset);
        }

        public final jnr.ffi.Address get() {
            return jnr.ffi.Address.valueOf(this.getMemory().getAddress(this.offset()));
        }

        public final void set(jnr.ffi.Address value) {
            this.getMemory().putAddress(this.offset(), value != null ? value.nativeAddress() : 0L);
        }

        public void set(Number value) {
            this.getMemory().putAddress(this.offset(), value.longValue());
        }

        public final int intValue() {
            return this.get().intValue();
        }

        public final long longValue() {
            return this.get().longValue();
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public final class Double
    extends NumberField {
        public Double() {
            super(NativeType.DOUBLE);
        }

        public Double(Offset offset) {
            super(NativeType.DOUBLE, offset);
        }

        public final double get() {
            return this.getMemory().getDouble(this.offset());
        }

        public final void set(double value) {
            this.getMemory().putDouble(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putDouble(this.offset(), value.doubleValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final float floatValue() {
            return (float)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    public class Float
    extends NumberField {
        public Float() {
            super(NativeType.FLOAT);
        }

        public Float(Offset offset) {
            super(NativeType.FLOAT, offset);
        }

        public final float get() {
            return this.getMemory().getFloat(this.offset());
        }

        public final void set(float value) {
            this.getMemory().putFloat(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putFloat(this.offset(), value.floatValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final float floatValue() {
            return this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    public class UnsignedLong
    extends NumberField {
        public UnsignedLong() {
            super(NativeType.ULONG);
        }

        public UnsignedLong(Offset offset) {
            super(NativeType.ULONG, offset);
        }

        public final long get() {
            long value = this.getMemory().getNativeLong(this.offset());
            long mask = Struct.this.getRuntime().findType(NativeType.SLONG).size() == 32 ? 0xFFFFFFFFL : -1L;
            return value < 0L ? (value & mask) + mask + 1L : value;
        }

        public final void set(long value) {
            this.getMemory().putNativeLong(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putNativeLong(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class SignedLong
    extends NumberField {
        public SignedLong() {
            super(NativeType.SLONG);
        }

        public SignedLong(Offset offset) {
            super(NativeType.SLONG, offset);
        }

        public final long get() {
            return this.getMemory().getNativeLong(this.offset());
        }

        public final void set(long value) {
            this.getMemory().putNativeLong(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putNativeLong(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned64
    extends NumberField {
        public Unsigned64() {
            super(NativeType.ULONGLONG);
        }

        public Unsigned64(Offset offset) {
            super(NativeType.ULONGLONG, offset);
        }

        public final long get() {
            return this.getMemory().getLong(this.offset());
        }

        public final void set(long value) {
            this.getMemory().putLong(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putLong(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Signed64
    extends NumberField {
        public Signed64() {
            super(NativeType.SLONGLONG);
        }

        public Signed64(Offset offset) {
            super(NativeType.SLONGLONG, offset);
        }

        public final long get() {
            return this.getMemory().getLong(this.offset());
        }

        public final void set(long value) {
            this.getMemory().putLong(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putLong(this.offset(), value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned32
    extends NumberField {
        public Unsigned32() {
            super(NativeType.UINT);
        }

        public Unsigned32(Offset offset) {
            super(NativeType.UINT, offset);
        }

        public final long get() {
            long value = this.getMemory().getInt(this.offset());
            return value < 0L ? (value & Integer.MAX_VALUE) + 0x80000000L : value;
        }

        public final void set(long value) {
            this.getMemory().putInt(this.offset(), (int)value);
        }

        public void set(Number value) {
            this.getMemory().putInt(this.offset(), value.intValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }
    }

    public class Signed32
    extends NumberField {
        public Signed32() {
            super(NativeType.SINT);
        }

        public Signed32(Offset offset) {
            super(NativeType.SINT, offset);
        }

        public final int get() {
            return this.getMemory().getInt(this.offset());
        }

        public final void set(int value) {
            this.getMemory().putInt(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putInt(this.offset(), value.intValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned16
    extends NumberField {
        public Unsigned16() {
            super(NativeType.USHORT);
        }

        public Unsigned16(Offset offset) {
            super(NativeType.USHORT, offset);
        }

        public final int get() {
            int value = this.getMemory().getShort(this.offset());
            return value < 0 ? (value & Short.MAX_VALUE) + 32768 : value;
        }

        public final void set(int value) {
            this.getMemory().putShort(this.offset(), (short)value);
        }

        public void set(Number value) {
            this.getMemory().putShort(this.offset(), value.shortValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed16
    extends NumberField {
        public Signed16() {
            super(NativeType.SSHORT);
        }

        public Signed16(Offset offset) {
            super(NativeType.SSHORT, offset);
        }

        public final short get() {
            return this.getMemory().getShort(this.offset());
        }

        public final void set(short value) {
            this.getMemory().putShort(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putShort(this.offset(), value.shortValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned8
    extends NumberField {
        public Unsigned8() {
            super(NativeType.UCHAR);
        }

        public Unsigned8(Offset offset) {
            super(NativeType.UCHAR, offset);
        }

        public final short get() {
            short value = this.getMemory().getByte(this.offset());
            return value < 0 ? (short)((value & 0x7F) + 128) : value;
        }

        public final void set(short value) {
            this.getMemory().putByte(this.offset(), (byte)value);
        }

        public void set(Number value) {
            this.getMemory().putByte(this.offset(), value.byteValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed8
    extends NumberField {
        public Signed8() {
            super(NativeType.SCHAR);
        }

        public Signed8(Offset offset) {
            super(NativeType.SCHAR, offset);
        }

        public final byte get() {
            return this.getMemory().getByte(this.offset());
        }

        public final void set(byte value) {
            this.getMemory().putByte(this.offset(), value);
        }

        public void set(Number value) {
            this.getMemory().putByte(this.offset(), value.byteValue());
        }

        public final byte byteValue() {
            return this.get();
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public abstract class NumberField
    implements Member {
        private final int offset;

        protected NumberField(NativeType type) {
            Type t = Struct.this.getRuntime().findType(type);
            this.offset = Struct.this.__info.addField(t.size() * 8, t.alignment() * 8);
        }

        protected NumberField(NativeType type, Offset offset) {
            Type t = Struct.this.getRuntime().findType(type);
            this.offset = Struct.this.__info.addField(t.size() * 8, t.alignment() * 8, offset);
        }

        public final jnr.ffi.Pointer getMemory() {
            return Struct.this.__info.getMemory();
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final long offset() {
            return this.offset + Struct.this.__info.offset;
        }

        public abstract void set(Number var1);

        public double doubleValue() {
            return this.longValue();
        }

        public float floatValue() {
            return this.intValue();
        }

        public byte byteValue() {
            return (byte)this.intValue();
        }

        public short shortValue() {
            return (short)this.intValue();
        }

        public abstract int intValue();

        public long longValue() {
            return this.intValue();
        }

        public java.lang.String toString() {
            return Integer.toString(this.intValue(), 10);
        }
    }

    public final class WBOOL
    extends AbstractBoolean {
        public WBOOL() {
            super(NativeType.SINT);
        }

        public final boolean get() {
            return (this.getMemory().getInt(this.offset()) & 1) != 0;
        }

        public final void set(boolean value) {
            this.getMemory().putInt(this.offset(), value ? 1 : 0);
        }
    }

    public final class Boolean
    extends AbstractBoolean {
        public Boolean() {
            super(NativeType.SCHAR);
        }

        public final boolean get() {
            return (this.getMemory().getByte(this.offset()) & 1) != 0;
        }

        public final void set(boolean value) {
            this.getMemory().putByte(this.offset(), (byte)(value ? 1 : 0));
        }
    }

    protected abstract class AbstractBoolean
    extends AbstractMember {
        protected AbstractBoolean(NativeType type) {
            super(type);
        }

        protected AbstractBoolean(NativeType type, Offset offset) {
            super(type, offset);
        }

        public abstract boolean get();

        public abstract void set(boolean var1);

        public java.lang.String toString() {
            return java.lang.Boolean.toString(this.get());
        }
    }

    protected abstract class AbstractMember
    implements Member {
        private final int offset;

        protected AbstractMember(int size) {
            this(size, size);
        }

        protected AbstractMember(int size, int align, Offset offset) {
            this.offset = Struct.this.__info.addField(size, align, offset);
        }

        protected AbstractMember(int size, int align) {
            this.offset = Struct.this.__info.addField(size, align);
        }

        protected AbstractMember(NativeType type) {
            Type t = Struct.this.getRuntime().findType(type);
            this.offset = Struct.this.__info.addField(t.size() * 8, t.alignment() * 8);
        }

        protected AbstractMember(NativeType type, Offset offset) {
            Type t = Struct.this.getRuntime().findType(type);
            this.offset = Struct.this.__info.addField(t.size() * 8, t.alignment() * 8, offset);
        }

        public final jnr.ffi.Pointer getMemory() {
            return Struct.this.__info.getMemory();
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final long offset() {
            return this.offset + Struct.this.__info.offset;
        }
    }

    protected static interface Member {
        public Struct struct();

        public jnr.ffi.Pointer getMemory();

        public long offset();
    }

    public static final class Offset
    extends Number {
        private final int offset;

        public Offset(int offset) {
            this.offset = offset;
        }

        public int intValue() {
            return this.offset;
        }

        public long longValue() {
            return this.offset;
        }

        public float floatValue() {
            return this.offset;
        }

        public double doubleValue() {
            return this.offset;
        }
    }

    static final class Info {
        private final Runtime runtime;
        private jnr.ffi.Pointer memory = null;
        Struct enclosing = null;
        int offset = 0;
        int size = 0;
        int minAlign = 1;
        boolean isUnion = false;
        boolean resetIndex = false;

        public Info(Runtime runtime) {
            this.runtime = runtime;
        }

        public final jnr.ffi.Pointer getMemory(int flags) {
            return this.enclosing != null ? this.enclosing.__info.getMemory(flags) : (this.memory != null ? this.memory : (this.memory = this.allocateMemory(flags)));
        }

        public final jnr.ffi.Pointer getMemory() {
            return this.getMemory(16);
        }

        final boolean isDirect() {
            return this.enclosing != null && this.enclosing.__info.isDirect() || this.memory != null && this.memory.isDirect();
        }

        final int size() {
            return this.size;
        }

        final int getMinimumAlignment() {
            return this.minAlign;
        }

        private final jnr.ffi.Pointer allocateMemory(int flags) {
            if (ParameterFlags.isDirect(flags)) {
                return this.runtime.getMemoryManager().allocateDirect(this.size(), true);
            }
            return this.runtime.getMemoryManager().allocate(this.size());
        }

        public final void useMemory(jnr.ffi.Pointer io) {
            this.memory = io;
        }

        protected final int addField(int sizeBits, int alignBits, Offset offset) {
            this.size = Math.max(this.size, offset.intValue() + (sizeBits >> 3));
            this.minAlign = Math.max(this.minAlign, alignBits >> 3);
            return offset.intValue();
        }

        protected final int addField(int sizeBits, int alignBits) {
            int off;
            int mask = (alignBits >> 3) - 1;
            int n = off = this.resetIndex ? 0 : this.size;
            if ((off & mask) != 0) {
                off = (off & ~mask) + (alignBits >> 3);
            }
            this.size = Math.max(this.size, off + (sizeBits >> 3));
            this.minAlign = Math.max(this.minAlign, alignBits >> 3);
            return off;
        }
    }
}

