/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.ObjectParameterInfo;
import com.kenai.jffi.ObjectParameterInvoker;
import com.kenai.jffi.ObjectParameterStrategy;
import com.kenai.jffi.Platform;

public abstract class Invoker {
    private static final long ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();
    private final Foreign foreign = Foreign.getInstance();
    private final ObjectParameterInvoker objectParameterInvoker = ObjectParameterInvoker.getInstance();

    public static final Invoker getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private Invoker() {
    }

    public final ObjectParameterInvoker getObjectParameterInvoker() {
        return this.objectParameterInvoker;
    }

    public final int invokeVrI(Function function) {
        return this.foreign.invokeVrI(function.getContextAddress());
    }

    public final float invokeVrF(Function function) {
        return this.foreign.invokeVrF(function.getContextAddress());
    }

    public final int invokeNoErrnoVrI(Function function) {
        return this.foreign.invokeNoErrnoVrI(function.getContextAddress());
    }

    public final int invokeIrI(Function function, int arg1) {
        return this.foreign.invokeIrI(function.getContextAddress(), arg1);
    }

    public final int invokeNoErrnoIrI(Function function, int arg1) {
        return this.foreign.invokeNoErrnoIrI(function.getContextAddress(), arg1);
    }

    public final float invokeIrF(Function function, int arg1) {
        return this.foreign.invokeIrF(function.getContextAddress(), arg1);
    }

    public final int invokeIIrI(Function function, int arg1, int arg2) {
        return this.foreign.invokeIIrI(function.getContextAddress(), arg1, arg2);
    }

    public final int invokeNoErrnoIIrI(Function function, int arg1, int arg2) {
        return this.foreign.invokeNoErrnoIIrI(function.getContextAddress(), arg1, arg2);
    }

    public final float invokeIIrF(Function function, int arg1, int arg2) {
        return this.foreign.invokeIIrF(function.getContextAddress(), arg1, arg2);
    }

    public final int invokeIIIrI(Function function, int arg1, int arg2, int arg3) {
        return this.foreign.invokeIIIrI(function.getContextAddress(), arg1, arg2, arg3);
    }

    public final int invokeNoErrnoIIIrI(Function function, int arg1, int arg2, int arg3) {
        return this.foreign.invokeNoErrnoIIIrI(function.getContextAddress(), arg1, arg2, arg3);
    }

    public final float invokeIIIrF(Function function, int arg1, int arg2, int arg3) {
        return this.foreign.invokeIIIrF(function.getContextAddress(), arg1, arg2, arg3);
    }

    public final long invokeVrL(Function function) {
        return this.foreign.invokeVrL(function.getContextAddress());
    }

    public final long invokeLrL(Function function, long arg1) {
        return this.foreign.invokeLrL(function.getContextAddress(), arg1);
    }

    public final long invokeLLrL(Function function, long arg1, long arg2) {
        return this.foreign.invokeLLrL(function.getContextAddress(), arg1, arg2);
    }

    public final long invokeLLLrL(Function function, long arg1, long arg2, long arg3) {
        return this.foreign.invokeLLLrL(function.getContextAddress(), arg1, arg2, arg3);
    }

    public final long invokeLLLLrL(Function function, long arg1, long arg2, long arg3, long arg4, long arg5) {
        return this.foreign.invokeLLLLrL(function.getContextAddress(), arg1, arg2, arg3, arg4);
    }

    public final long invokeLLLLLrL(Function function, long arg1, long arg2, long arg3, long arg4, long arg5) {
        return this.foreign.invokeLLLLLrL(function.getContextAddress(), arg1, arg2, arg3, arg4, arg5);
    }

    public final long invokeLLLLLLrL(Function function, long arg1, long arg2, long arg3, long arg4, long arg5, long arg6) {
        return this.foreign.invokeLLLLLLrL(function.getContextAddress(), arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public final long invokeVrN(Function function) {
        return this.foreign.invokeVrN(function.getContextAddress());
    }

    public final long invokeNrN(Function function, long arg1) {
        return this.foreign.invokeNrN(function.getContextAddress(), arg1);
    }

    public final long invokeNNrN(Function function, long arg1, long arg2) {
        return this.foreign.invokeNNrN(function.getContextAddress(), arg1, arg2);
    }

    public final long invokeNNNrN(Function function, long arg1, long arg2, long arg3) {
        return this.foreign.invokeNNNrN(function.getContextAddress(), arg1, arg2, arg3);
    }

    public final long invokeNNNNrN(Function function, long arg1, long arg2, long arg3, long arg4) {
        return this.foreign.invokeNNNNrN(function.getContextAddress(), arg1, arg2, arg3, arg4);
    }

    public final long invokeNNNNNrN(Function function, long arg1, long arg2, long arg3, long arg4, long arg5) {
        return this.foreign.invokeNNNNNrN(function.getContextAddress(), arg1, arg2, arg3, arg4, arg5);
    }

    public final long invokeNNNNNNrN(Function function, long arg1, long arg2, long arg3, long arg4, long arg5, long arg6) {
        return this.foreign.invokeNNNNNNrN(function.getContextAddress(), arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public final long invokeNNO1rN(Function function, long n1, long n2, Object o1, int o1off, int o1len, ObjectParameterInfo o1flags) {
        return this.objectParameterInvoker.invokeN2O1rN(function, n1, n2, o1, o1off, o1len, o1flags);
    }

    public final long invokeNNO2rN(Function function, long n1, long n2, Object o1, int o1off, int o1len, ObjectParameterInfo o1flags, Object o2, int o2off, int o2len, ObjectParameterInfo o2flags) {
        return this.objectParameterInvoker.invokeN2O2rN(function, n1, n2, o1, o1off, o1len, o1flags, o2, o2off, o2len, o2flags);
    }

    public final long invokeNNNO1rN(Function function, long n1, long n2, long n3, Object o1, int o1off, int o1len, ObjectParameterInfo o1flags) {
        return this.objectParameterInvoker.invokeN3O1rN(function, n1, n2, n3, o1, o1off, o1len, o1flags);
    }

    public final long invokeNNNO2rN(Function function, long n1, long n2, long n3, Object o1, int o1off, int o1len, ObjectParameterInfo o1flags, Object o2, int o2off, int o2len, ObjectParameterInfo o2flags) {
        return this.objectParameterInvoker.invokeN3O2rN(function, n1, n2, n3, o1, o1off, o1len, o1flags, o2, o2off, o2len, o2flags);
    }

    private static RuntimeException newObjectCountError(int objCount) {
        return new RuntimeException("invalid object count: " + objCount);
    }

    private static RuntimeException newHeapObjectCountError(int objCount) {
        return new RuntimeException("insufficient number of heap objects supplied (" + objCount + " required)");
    }

    public final long invokeN1OrN(Function function, long n1, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info) {
        return this.objectParameterInvoker.invokeN1O1rN(function, n1, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
    }

    public final long invokeN2OrN(Function function, long n1, long n2, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info) {
        return this.objectParameterInvoker.invokeN2O1rN(function, n1, n2, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
    }

    public final long invokeN2OrN(Function function, long n1, long n2, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info, Object o2, ObjectParameterStrategy s2, ObjectParameterInfo o2info) {
        if (objCount == 1) {
            if (s1.isDirect()) {
                o1 = o2;
                s1 = s2;
                o1info = o2info;
            }
            return this.objectParameterInvoker.invokeN2O1rN(function, n1, n2, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
        }
        if (objCount == 2) {
            return this.objectParameterInvoker.invokeN2O2rN(function, n1, n2, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info);
        }
        throw Invoker.newObjectCountError(objCount);
    }

    public final long invokeN3OrN(Function function, long n1, long n2, long n3, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info) {
        return this.objectParameterInvoker.invokeN3O1rN(function, n1, n2, n3, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
    }

    public final long invokeN3OrN(Function function, long n1, long n2, long n3, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info, Object o2, ObjectParameterStrategy s2, ObjectParameterInfo o2info) {
        if (objCount == 1) {
            if (s1.isDirect()) {
                o1 = o2;
                s1 = s2;
                o1info = o2info;
            }
            return this.objectParameterInvoker.invokeN3O1rN(function, n1, n2, n3, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
        }
        if (objCount == 2) {
            return this.objectParameterInvoker.invokeN3O2rN(function, n1, n2, n3, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info);
        }
        throw Invoker.newObjectCountError(objCount);
    }

    public final long invokeN3OrN(Function function, long n1, long n2, long n3, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info, Object o2, ObjectParameterStrategy s2, ObjectParameterInfo o2info, Object o3, ObjectParameterStrategy s3, ObjectParameterInfo o3info) {
        if (objCount < 3) {
            int next;
            if (!s1.isDirect()) {
                next = 2;
            } else if (!s2.isDirect()) {
                o1 = o2;
                s1 = s2;
                o1info = o2info;
                next = 3;
            } else {
                o1 = o3;
                s1 = s3;
                o1info = o3info;
                next = 4;
            }
            if (objCount == 1) {
                return this.objectParameterInvoker.invokeN3O1rN(function, n1, n2, n3, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
            }
            if (objCount == 2) {
                if (next > 2 || s2.isDirect()) {
                    if (next <= 3) {
                        o2 = o3;
                        s2 = s3;
                        o2info = o3info;
                    } else {
                        throw Invoker.newHeapObjectCountError(objCount);
                    }
                }
                return this.objectParameterInvoker.invokeN3O2rN(function, n1, n2, n3, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info);
            }
            throw Invoker.newObjectCountError(objCount);
        }
        return this.objectParameterInvoker.invokeN3O3rN(function, n1, n2, n3, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info, s3.object(o3), s3.offset(o3), s3.length(o3), o3info);
    }

    public final long invokeN4OrN(Function function, long n1, long n2, long n3, long n4, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info) {
        return this.objectParameterInvoker.invokeN4O1rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
    }

    public final long invokeN4OrN(Function function, long n1, long n2, long n3, long n4, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info, Object o2, ObjectParameterStrategy s2, ObjectParameterInfo o2info) {
        if (objCount == 1) {
            if (s1.isDirect()) {
                o1 = o2;
                s1 = s2;
                o1info = o2info;
            }
            return this.objectParameterInvoker.invokeN4O1rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
        }
        if (objCount == 2) {
            return this.objectParameterInvoker.invokeN4O2rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info);
        }
        throw Invoker.newObjectCountError(objCount);
    }

    public final long invokeN4OrN(Function function, long n1, long n2, long n3, long n4, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info, Object o2, ObjectParameterStrategy s2, ObjectParameterInfo o2info, Object o3, ObjectParameterStrategy s3, ObjectParameterInfo o3info) {
        if (objCount < 3) {
            int next;
            if (!s1.isDirect()) {
                next = 2;
            } else if (!s2.isDirect()) {
                o1 = o2;
                s1 = s2;
                o1info = o2info;
                next = 3;
            } else {
                o1 = o3;
                s1 = s3;
                o1info = o3info;
                next = 4;
            }
            if (objCount == 1) {
                return this.objectParameterInvoker.invokeN4O1rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
            }
            if (objCount == 2) {
                if (next > 2 || s2.isDirect()) {
                    if (next <= 3 && !s3.isDirect()) {
                        o2 = o3;
                        s2 = s3;
                        o2info = o3info;
                    } else {
                        throw Invoker.newHeapObjectCountError(objCount);
                    }
                }
                return this.objectParameterInvoker.invokeN4O2rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info);
            }
            throw Invoker.newObjectCountError(objCount);
        }
        return this.objectParameterInvoker.invokeN4O3rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info, s3.object(o3), s3.offset(o3), s3.length(o3), o3info);
    }

    public final long invokeN4OrN(Function function, long n1, long n2, long n3, long n4, int objCount, Object o1, ObjectParameterStrategy s1, ObjectParameterInfo o1info, Object o2, ObjectParameterStrategy s2, ObjectParameterInfo o2info, Object o3, ObjectParameterStrategy s3, ObjectParameterInfo o3info, Object o4, ObjectParameterStrategy s4, ObjectParameterInfo o4info) {
        int next;
        if (!s1.isDirect()) {
            next = 2;
        } else if (!s2.isDirect()) {
            o1 = o2;
            s1 = s2;
            o1info = o2info;
            next = 3;
        } else if (!s3.isDirect()) {
            o1 = o3;
            s1 = s3;
            o1info = o3info;
            next = 4;
        } else {
            o1 = o4;
            s1 = s4;
            o1info = o4info;
            next = 5;
        }
        if (objCount == 1) {
            return this.objectParameterInvoker.invokeN4O1rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info);
        }
        if (next <= 2 && !s2.isDirect()) {
            next = 3;
        } else if (next <= 3 && !s3.isDirect()) {
            o2 = o3;
            s2 = s3;
            o2info = o3info;
            next = 4;
        } else if (next <= 4) {
            o2 = o4;
            s2 = s4;
            o2info = o4info;
            next = 5;
        }
        if (objCount == 2) {
            return this.objectParameterInvoker.invokeN4O2rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info);
        }
        if (next > 3 || s3.isDirect()) {
            if (next <= 4) {
                o3 = o4;
                s3 = s4;
                o3info = o4info;
            } else {
                throw Invoker.newHeapObjectCountError(objCount);
            }
        }
        if (objCount == 3) {
            return this.objectParameterInvoker.invokeN4O3rN(function, n1, n2, n3, n4, s1.object(o1), s1.offset(o1), s1.length(o1), o1info, s2.object(o2), s2.offset(o2), s2.length(o2), o2info, s3.object(o3), s3.offset(o3), s3.length(o3), o3info);
        }
        throw Invoker.newObjectCountError(objCount);
    }

    public abstract long invokeAddress(Function var1, HeapInvocationBuffer var2);

    public abstract long invokeAddress(CallContext var1, long var2, HeapInvocationBuffer var4);

    public final int invokeInt(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.invokeArrayWithObjectsInt32(function, buffer, objectBuffer) : this.foreign.invokeArrayReturnInt(function.getContextAddress(), buffer.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int invokeInt(CallContext ctx, long function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        long fnHandle = this.newFunction(ctx, function);
        try {
            int n = objectBuffer != null ? this.invokeArrayWithObjectsInt32(fnHandle, buffer, objectBuffer) : this.foreign.invokeArrayReturnInt(fnHandle, buffer.array());
            return n;
        }
        finally {
            this.foreign.freeFunction(fnHandle);
        }
    }

    public final long invokeLong(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsInt64(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnLong(function.getContextAddress(), buffer.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long invokeLong(CallContext ctx, long function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        long fnHandle = this.newFunction(ctx, function);
        try {
            long l = objectBuffer != null ? this.invokeArrayWithObjectsInt64(fnHandle, buffer, objectBuffer) : this.foreign.invokeArrayReturnLong(fnHandle, buffer.array());
            return l;
        }
        finally {
            this.foreign.freeFunction(fnHandle);
        }
    }

    public final float invokeFloat(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsFloat(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnFloat(function.getContextAddress(), buffer.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float invokeFloat(CallContext ctx, long function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        long fnHandle = this.newFunction(ctx, function);
        try {
            float f = objectBuffer != null ? this.foreign.invokeArrayWithObjectsFloat(fnHandle, buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnFloat(fnHandle, buffer.array());
            return f;
        }
        finally {
            this.foreign.freeFunction(fnHandle);
        }
    }

    public final double invokeDouble(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsDouble(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnDouble(function.getContextAddress(), buffer.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double invokeDouble(CallContext ctx, long function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        long fnHandle = this.newFunction(ctx, function);
        try {
            double d = objectBuffer != null ? this.foreign.invokeArrayWithObjectsDouble(fnHandle, buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnDouble(fnHandle, buffer.array());
            return d;
        }
        finally {
            this.foreign.freeFunction(fnHandle);
        }
    }

    public final byte[] invokeStruct(Function function, HeapInvocationBuffer buffer) {
        byte[] returnBuffer = new byte[function.getReturnType().size()];
        this.invokeStruct(function, buffer, returnBuffer, 0);
        return returnBuffer;
    }

    public final byte[] invokeStruct(CallContext ctx, long function, HeapInvocationBuffer buffer) {
        byte[] returnBuffer = new byte[ctx.getReturnType().size()];
        this.invokeStruct(ctx, function, buffer, returnBuffer, 0);
        return returnBuffer;
    }

    public final void invokeStruct(Function function, HeapInvocationBuffer buffer, byte[] returnBuffer, int offset) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        if (objectBuffer != null) {
            this.foreign.invokeArrayWithObjectsReturnStruct(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects(), returnBuffer, offset);
        } else {
            this.foreign.invokeArrayReturnStruct(function.getContextAddress(), buffer.array(), returnBuffer, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeStruct(CallContext ctx, long function, HeapInvocationBuffer buffer, byte[] returnBuffer, int offset) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        long fnHandle = this.newFunction(ctx, function);
        try {
            if (objectBuffer != null) {
                this.foreign.invokeArrayWithObjectsReturnStruct(fnHandle, buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects(), returnBuffer, offset);
            } else {
                this.foreign.invokeArrayReturnStruct(fnHandle, buffer.array(), returnBuffer, offset);
            }
        }
        finally {
            this.foreign.freeFunction(fnHandle);
        }
    }

    public final Object invokeObject(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return this.foreign.invokeArrayWithObjectsReturnObject(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects());
    }

    public final void invoke(Function function, long returnBuffer, long[] parameters) {
        this.foreign.invokePointerParameterArray(function.getContextAddress(), returnBuffer, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(CallContext ctx, long function, long returnBuffer, long[] parameters) {
        long fnHandle = this.newFunction(ctx, function);
        try {
            this.foreign.invokePointerParameterArray(fnHandle, returnBuffer, parameters);
        }
        finally {
            this.foreign.freeFunction(fnHandle);
        }
    }

    private final int invokeArrayWithObjectsInt32(Function function, HeapInvocationBuffer buffer, ObjectBuffer objectBuffer) {
        return this.invokeArrayWithObjectsInt32(function.getContextAddress(), buffer, objectBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int invokeArrayWithObjectsInt32(CallContext ctx, long function, HeapInvocationBuffer buffer, ObjectBuffer objectBuffer) {
        long fnHandle = this.newFunction(ctx, function);
        try {
            int n = this.invokeArrayWithObjectsInt32(fnHandle, buffer, objectBuffer);
            return n;
        }
        finally {
            this.foreign.freeFunction(fnHandle);
        }
    }

    private final int invokeArrayWithObjectsInt32(long fnHandle, HeapInvocationBuffer buffer, ObjectBuffer objectBuffer) {
        Object[] objects = objectBuffer.objects();
        int[] info = objectBuffer.info();
        int objectCount = objectBuffer.objectCount();
        switch (objectCount) {
            case 1: {
                return this.foreign.invokeArrayO1Int32(fnHandle, buffer.array(), objects[0], info[0], info[1], info[2]);
            }
            case 2: {
                return this.foreign.invokeArrayO2Int32(fnHandle, buffer.array(), objects[0], info[0], info[1], info[2], objects[1], info[3], info[4], info[5]);
            }
        }
        return this.foreign.invokeArrayWithObjectsInt32(fnHandle, buffer.array(), objectCount, info, objects);
    }

    private final long invokeArrayWithObjectsInt64(long fnHandle, HeapInvocationBuffer buffer, ObjectBuffer objectBuffer) {
        Object[] objects = objectBuffer.objects();
        int[] info = objectBuffer.info();
        int objectCount = objectBuffer.objectCount();
        switch (objectCount) {
            case 1: {
                return this.foreign.invokeArrayO1Int64(fnHandle, buffer.array(), objects[0], info[0], info[1], info[2]);
            }
            case 2: {
                return this.foreign.invokeArrayO2Int64(fnHandle, buffer.array(), objects[0], info[0], info[1], info[2], objects[1], info[3], info[4], info[5]);
            }
        }
        return this.foreign.invokeArrayWithObjectsInt64(fnHandle, buffer.array(), objectCount, info, objects);
    }

    private long newFunction(CallContext ctx, long function) {
        return this.foreign.newFunction(function, ctx.getReturnType().handle(), ctx.parameterTypeHandles, ctx.flags);
    }

    static /* synthetic */ long access$000() {
        return ADDRESS_SIZE;
    }

    private static final class LP64
    extends Invoker {
        private static final Invoker INSTANCE = new LP64();

        private LP64() {
        }

        public long invokeAddress(Function function, HeapInvocationBuffer buffer) {
            return this.invokeLong(function, buffer);
        }

        public final long invokeAddress(CallContext ctx, long function, HeapInvocationBuffer buffer) {
            return this.invokeLong(ctx, function, buffer);
        }

        static /* synthetic */ Invoker access$100() {
            return INSTANCE;
        }
    }

    private static final class ILP32
    extends Invoker {
        private static final Invoker INSTANCE = new ILP32();

        private ILP32() {
        }

        public final long invokeAddress(Function function, HeapInvocationBuffer buffer) {
            return (long)this.invokeInt(function, buffer) & ADDRESS_MASK;
        }

        public final long invokeAddress(CallContext ctx, long function, HeapInvocationBuffer buffer) {
            return (long)this.invokeInt(ctx, function, buffer) & ADDRESS_MASK;
        }

        static /* synthetic */ Invoker access$200() {
            return INSTANCE;
        }
    }

    private static final class SingletonHolder {
        private static final Invoker INSTANCE = Invoker.access$000() == 64L ? LP64.access$100() : ILP32.access$200();

        private SingletonHolder() {
        }
    }
}

