/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.gradle;

import git.semver.plugin.gradle.GitSemverPluginExtension;
import git.semver.plugin.gradle.PrintTask;
import git.semver.plugin.gradle.ReleaseTask;
import git.semver.plugin.scm.Commit;
import git.semver.plugin.scm.GitProvider;
import git.semver.plugin.semver.SemverSettings;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lgit/semver/plugin/gradle/GitSemverPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "git-semver-plugin"})
public final class GitSemverPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String VERSIONING_GROUP = "Versioning";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[]{project};
        GitSemverPluginExtension extension = (GitSemverPluginExtension)project.getExtensions().create("semver", GitSemverPluginExtension.class, objectArray);
        TaskContainer taskContainer = project.getTasks();
        objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)extension);
        objectArray[0] = new PropertyReference0Impl(extension){

            @Nullable
            public Object get() {
                return ((GitSemverPluginExtension)this.receiver).getVersionValue();
            }
        };
        objectArray[1] = "Prints the current project version";
        taskContainer.register("printVersion", PrintTask.class, objectArray);
        objectArray = new Object[]{new PropertyReference0Impl(extension){

            @Nullable
            public Object get() {
                return ((GitSemverPluginExtension)this.receiver).getSemVersion();
            }
        }, "Prints the current project semantic version"};
        project.getTasks().register("printSemVersion", PrintTask.class, objectArray);
        objectArray = new Object[]{new PropertyReference0Impl(extension){

            @Nullable
            public Object get() {
                return ((GitSemverPluginExtension)this.receiver).getInfoVersion();
            }
        }, "Prints the current project info version"};
        project.getTasks().register("printInfoVersion", PrintTask.class, objectArray);
        if (Intrinsics.areEqual((Object)project, (Object)project.getRootProject())) {
            objectArray = new Object[]{new Function0<String>(extension){
                final /* synthetic */ GitSemverPluginExtension $extension;
                {
                    this.$extension = $extension;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    SemverSettings settings = this.$extension.createSettings$git_semver_plugin();
                    GitProvider gitProvider = new GitProvider(settings);
                    File file = ((Directory)this.$extension.getGitDir$git_semver_plugin().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                    List<Commit> changeLog = gitProvider.getChangeLog$git_semver_plugin(file);
                    return this.$extension.getChangeLogFormat().formatLog(changeLog, settings, this.$extension.getChangeLogTexts());
                }
            }, "Prints a change log"};
            project.getTasks().register("printChangeLog", PrintTask.class, objectArray);
            objectArray = new Object[]{extension};
            project.getTasks().register("releaseVersion", ReleaseTask.class, objectArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit/semver/plugin/gradle/GitSemverPlugin$Companion;", "", "()V", "VERSIONING_GROUP", "", "git-semver-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

