/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.semver;

import git.semver.plugin.scm.Commit;
import git.semver.plugin.scm.IRefInfo;
import git.semver.plugin.semver.MutableSemVersion;
import git.semver.plugin.semver.SemInfoVersion;
import git.semver.plugin.semver.SemverSettings;
import git.semver.plugin.semver.VersionFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u000212B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0012\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0007H\u0002J\u0016\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010\u0006J \u0010\"\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u001a\u0010%\u001a\u00020\u001d2\b\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J<\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00102\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000e0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150/H\u0002J\b\u00100\u001a\u00020\u000eH\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lgit/semver/plugin/semver/VersionFinder;", "", "settings", "Lgit/semver/plugin/semver/SemverSettings;", "tags", "", "", "", "Lgit/semver/plugin/scm/IRefInfo;", "(Lgit/semver/plugin/semver/SemverSettings;Ljava/util/Map;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "findVersion", "Lgit/semver/plugin/semver/MutableSemVersion;", "startCommit", "Lgit/semver/plugin/scm/Commit;", "getChangeLog", "commit", "", "commitData", "Lgit/semver/plugin/semver/VersionFinder$CommitData;", "getCombinedParentVersion", "parentSemVersions", "getIncludedCommits", "Lgit/semver/plugin/semver/VersionFinder$IncludedCommits;", "commitsList", "Lkotlin/sequences/Sequence;", "stopAtPreRelease", "", "getReleaseSemVersionFromCommit", "getReleaseVersion", "Lgit/semver/plugin/semver/SemInfoVersion;", "newPreRelease", "getVersion", "isClean", "defaultPreRelease", "isRelease", "releaseVersion", "markParentCommitsAsVisited", "", "liveBranchCount", "", "currentCommit", "visitedCommits", "", "commits", "Ljava/util/PriorityQueue;", "versionZero", "CommitData", "IncludedCommits", "git-semver-plugin"})
@SourceDebugExtension(value={"SMAP\nVersionFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionFinder.kt\ngit/semver/plugin/semver/VersionFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,176:1\n766#2:177\n857#2,2:178\n1549#2:180\n1620#2,3:181\n1603#2,9:184\n1855#2:193\n1856#2:195\n1612#2:196\n1603#2,9:201\n1855#2:210\n1856#2:212\n1612#2:213\n1#3:194\n1#3:211\n1313#4,2:197\n1313#4,2:199\n*S KotlinDebug\n*F\n+ 1 VersionFinder.kt\ngit/semver/plugin/semver/VersionFinder\n*L\n46#1:177\n46#1:178,2\n47#1:180\n47#1:181,3\n65#1:184,9\n65#1:193\n65#1:195\n65#1:196\n174#1:201,9\n174#1:210\n174#1:212\n174#1:213\n65#1:194\n174#1:211\n128#1:197,2\n159#1:199,2\n*E\n"})
public final class VersionFinder {
    @NotNull
    private final SemverSettings settings;
    @NotNull
    private final Map<String, List<IRefInfo>> tags;
    private final Logger logger;

    public VersionFinder(@NotNull SemverSettings settings, @NotNull Map<String, ? extends List<? extends IRefInfo>> tags) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.settings = settings;
        this.tags = tags;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final SemInfoVersion getVersion(@NotNull Commit commit, boolean isClean, @Nullable String defaultPreRelease) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        MutableSemVersion semVersion = this.findVersion(commit);
        boolean isModified = semVersion.getCommitCount() > 0 || !isClean;
        boolean updated = semVersion.applyPendingChanges$git_semver_plugin(isModified && !this.settings.getNoAutoBump(), this.settings.getGroupVersionIncrements());
        if (!semVersion.isPreRelease() && updated) {
            semVersion.setPreRelease$git_semver_plugin(defaultPreRelease);
        }
        return semVersion.toSemVersion();
    }

    @NotNull
    public final SemInfoVersion getReleaseVersion(@NotNull Commit commit, @Nullable String newPreRelease) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        MutableSemVersion semVersion = this.findVersion(commit);
        semVersion.setCommitCount(0);
        semVersion.applyPendingChanges$git_semver_plugin(!semVersion.isPreRelease() || !Intrinsics.areEqual((Object)"", (Object)newPreRelease), this.settings.getGroupVersionIncrements());
        if (newPreRelease != null) {
            semVersion.setPreRelease$git_semver_plugin(newPreRelease);
        }
        return semVersion.toSemVersion();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Commit> getChangeLog(@NotNull Commit commit) {
        List<Commit> list;
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        MutableSemVersion release = this.getReleaseSemVersionFromCommit(commit);
        if (this.isRelease(release, true)) {
            void var3_3;
            List<Commit> changeLog = this.getChangeLog(this.getIncludedCommits(commit.getParents(), true).getIncludedCommits());
            changeLog.add(commit);
            list = var3_3;
        } else {
            Object[] objectArray = new Commit[]{commit};
            list = this.getChangeLog(this.getIncludedCommits((Sequence<Commit>)SequencesKt.sequenceOf((Object[])objectArray), true).getIncludedCommits());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Commit> getChangeLog(List<CommitData> commitData) {
        void $this$mapTo$iv$iv;
        CommitData it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.asReversed(commitData);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CommitData)element$iv$iv;
            boolean bl = false;
            if (!(it.getParents().size() <= 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CommitData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCommit());
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final MutableSemVersion findVersion(Commit startCommit) {
        if (StringsKt.isBlank((CharSequence)startCommit.getSha())) {
            return this.versionZero();
        }
        Object[] objectArray = new Commit[]{startCommit};
        IncludedCommits result = this.getIncludedCommits((Sequence<Commit>)SequencesKt.sequenceOf((Object[])objectArray), false);
        MutableSemVersion lastFoundVersion = result.getLastFoundVersion();
        for (CommitData commitData : CollectionsKt.asReversed(result.getIncludedCommits())) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            MutableSemVersion preReleaseVersion = result.getVisitedCommits().get(commitData.getCommit().getSha());
            Iterable iterable = commitData.getParents();
            boolean $i$f$mapNotNull = false;
            void var10_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                MutableSemVersion it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (result.getVisitedCommits().remove(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List parentSemVersions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            MutableSemVersion maxVersionFromParents = this.getCombinedParentVersion(parentSemVersions);
            maxVersionFromParents.updateFromCommit$git_semver_plugin(commitData.getCommit(), this.settings, preReleaseVersion);
            result.getVisitedCommits().put(commitData.getCommit().getSha(), maxVersionFromParents);
            lastFoundVersion = maxVersionFromParents;
        }
        return lastFoundVersion;
    }

    private final IncludedCommits getIncludedCommits(Sequence<Commit> commitsList, boolean stopAtPreRelease) {
        int liveBranchCount = 1;
        MutableSemVersion lastFoundVersion = this.versionZero();
        PriorityQueue<CommitData> commits2 = new PriorityQueue<CommitData>(SequencesKt.toList((Sequence)SequencesKt.map(commitsList, (Function1)getIncludedCommits.commits.1.INSTANCE)));
        Map visitedCommits = new LinkedHashMap();
        List includedCommits = new ArrayList();
        while (!((Collection)commits2).isEmpty()) {
            CommitData commitData = (CommitData)commits2.remove();
            Commit currentCommit = commitData.getCommit();
            if (commitData.isParentOfReleaseCommit()) {
                this.markParentCommitsAsVisited(liveBranchCount, currentCommit, visitedCommits, commits2);
                continue;
            }
            if (visitedCommits.containsKey(currentCommit.getSha())) continue;
            MutableSemVersion releaseVersion = this.getReleaseSemVersionFromCommit(currentCommit);
            visitedCommits.put(currentCommit.getSha(), releaseVersion);
            if (this.isRelease(releaseVersion, stopAtPreRelease)) {
                this.logger.debug("Release version found: {}", (Object)releaseVersion);
                Intrinsics.checkNotNull((Object)releaseVersion);
                this.markParentCommitsAsVisited(--liveBranchCount, currentCommit, visitedCommits, commits2);
                continue;
            }
            Intrinsics.checkNotNull((Object)commitData);
            includedCommits.add(commitData);
            Sequence<Commit> $this$forEach$iv = currentCommit.getParents();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Commit it = (Commit)element$iv;
                boolean bl = false;
                commitData.getParents().add(it.getSha());
                if (visitedCommits.containsKey(it.getSha())) continue;
                commits2.add(new CommitData(it, null, false, 6, null));
            }
            liveBranchCount += commitData.getParents().size() - 1;
        }
        return new IncludedCommits(lastFoundVersion, visitedCommits, includedCommits);
    }

    private final MutableSemVersion getCombinedParentVersion(List<MutableSemVersion> parentSemVersions) {
        return parentSemVersions.isEmpty() ? this.versionZero() : (parentSemVersions.size() == 1 ? parentSemVersions.get(0) : ((MutableSemVersion)CollectionsKt.maxOrThrow((Iterable)parentSemVersions)).mergeChanges$git_semver_plugin(parentSemVersions));
    }

    private final void markParentCommitsAsVisited(int liveBranchCount, Commit currentCommit, Map<String, MutableSemVersion> visitedCommits, PriorityQueue<CommitData> commits2) {
        if (liveBranchCount == 0) {
            return;
        }
        Sequence $this$forEach$iv = SequencesKt.filter(currentCommit.getParents(), (Function1)((Function1)new Function1<Commit, Boolean>(visitedCommits){
            final /* synthetic */ Map<String, MutableSemVersion> $visitedCommits;
            {
                this.$visitedCommits = $visitedCommits;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Commit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$visitedCommits.containsKey(it.getSha());
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Commit it = (Commit)element$iv;
            boolean bl = false;
            visitedCommits.put(it.getSha(), null);
            commits2.add(new CommitData(it, new ArrayList(1), true));
        }
    }

    private final boolean isRelease(MutableSemVersion releaseVersion, boolean stopAtPreRelease) {
        return releaseVersion != null && (stopAtPreRelease || !releaseVersion.isPreRelease());
    }

    private final MutableSemVersion versionZero() {
        return new MutableSemVersion();
    }

    /*
     * WARNING - void declaration
     */
    private final MutableSemVersion getReleaseSemVersionFromCommit(Commit commit) {
        MutableSemVersion mutableSemVersion;
        if (MutableSemVersion.Companion.isRelease(commit, this.settings)) {
            mutableSemVersion = MutableSemVersion.Companion.tryParse(commit);
        } else {
            List<IRefInfo> list = this.tags.get(commit.getSha());
            if (list != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = list;
                MutableSemVersion.Companion companion = MutableSemVersion.Companion;
                boolean $i$f$mapNotNull = false;
                void var5_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    MutableSemVersion it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    IRefInfo p0 = (IRefInfo)element$iv$iv;
                    boolean bl2 = false;
                    if (companion.tryParse(p0) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                mutableSemVersion = (MutableSemVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
            } else {
                mutableSemVersion = null;
            }
        }
        return mutableSemVersion;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lgit/semver/plugin/semver/VersionFinder$CommitData;", "", "commit", "Lgit/semver/plugin/scm/Commit;", "parents", "", "", "isParentOfReleaseCommit", "", "(Lgit/semver/plugin/scm/Commit;Ljava/util/List;Z)V", "getCommit", "()Lgit/semver/plugin/scm/Commit;", "()Z", "getParents", "()Ljava/util/List;", "compareTo", "", "other", "git-semver-plugin"})
    private static final class CommitData
    implements Comparable<CommitData> {
        @NotNull
        private final Commit commit;
        @NotNull
        private final List<String> parents;
        private final boolean isParentOfReleaseCommit;

        public CommitData(@NotNull Commit commit, @NotNull List<String> parents, boolean isParentOfReleaseCommit) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter(parents, (String)"parents");
            this.commit = commit;
            this.parents = parents;
            this.isParentOfReleaseCommit = isParentOfReleaseCommit;
        }

        public /* synthetic */ CommitData(Commit commit, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = new ArrayList(1);
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            this(commit, list, bl);
        }

        @NotNull
        public final Commit getCommit() {
            return this.commit;
        }

        @NotNull
        public final List<String> getParents() {
            return this.parents;
        }

        public final boolean isParentOfReleaseCommit() {
            return this.isParentOfReleaseCommit;
        }

        @Override
        public int compareTo(@NotNull CommitData other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((int)other.commit.getCommitTime(), (int)this.commit.getCommitTime());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgit/semver/plugin/semver/VersionFinder$IncludedCommits;", "", "lastFoundVersion", "Lgit/semver/plugin/semver/MutableSemVersion;", "visitedCommits", "", "", "includedCommits", "", "Lgit/semver/plugin/semver/VersionFinder$CommitData;", "(Lgit/semver/plugin/semver/MutableSemVersion;Ljava/util/Map;Ljava/util/List;)V", "getIncludedCommits", "()Ljava/util/List;", "getLastFoundVersion", "()Lgit/semver/plugin/semver/MutableSemVersion;", "getVisitedCommits", "()Ljava/util/Map;", "git-semver-plugin"})
    private static final class IncludedCommits {
        @NotNull
        private final MutableSemVersion lastFoundVersion;
        @NotNull
        private final Map<String, MutableSemVersion> visitedCommits;
        @NotNull
        private final List<CommitData> includedCommits;

        public IncludedCommits(@NotNull MutableSemVersion lastFoundVersion, @NotNull Map<String, MutableSemVersion> visitedCommits, @NotNull List<CommitData> includedCommits) {
            Intrinsics.checkNotNullParameter((Object)lastFoundVersion, (String)"lastFoundVersion");
            Intrinsics.checkNotNullParameter(visitedCommits, (String)"visitedCommits");
            Intrinsics.checkNotNullParameter(includedCommits, (String)"includedCommits");
            this.lastFoundVersion = lastFoundVersion;
            this.visitedCommits = visitedCommits;
            this.includedCommits = includedCommits;
        }

        @NotNull
        public final MutableSemVersion getLastFoundVersion() {
            return this.lastFoundVersion;
        }

        @NotNull
        public final Map<String, MutableSemVersion> getVisitedCommits() {
            return this.visitedCommits;
        }

        @NotNull
        public final List<CommitData> getIncludedCommits() {
            return this.includedCommits;
        }
    }
}

