/*
 * Decompiled with CFR 0.152.
 */
package git.semver.plugin.semver;

import git.semver.plugin.scm.Commit;
import git.semver.plugin.scm.IRefInfo;
import git.semver.plugin.semver.MutableSemVersion;
import git.semver.plugin.semver.SemInfoVersion;
import git.semver.plugin.semver.SemverSettings;
import git.semver.plugin.semver.VersionFinder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001.B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\u0002\u0010\tJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012H\u0002J&\u0010\u0015\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012H\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u001b\u001a\u00020\u0010J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006J \u0010 \u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010\u0006J\u0012\u0010#\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002J<\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00160)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\b\u0010-\u001a\u00020\u0016H\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit/semver/plugin/semver/VersionFinder;", "", "settings", "Lgit/semver/plugin/semver/SemverSettings;", "tags", "", "", "", "Lgit/semver/plugin/scm/IRefInfo;", "(Lgit/semver/plugin/semver/SemverSettings;Ljava/util/Map;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addToChangeLog", "", "currentCommit", "Lgit/semver/plugin/scm/Commit;", "changeLog", "", "isMergeCommit", "", "findVersion", "Lgit/semver/plugin/semver/MutableSemVersion;", "startCommit", "commitsList", "Lkotlin/sequences/Sequence;", "getChangeLog", "commit", "getReleaseSemVersionFromCommit", "getReleaseVersion", "Lgit/semver/plugin/semver/SemInfoVersion;", "newPreRelease", "getVersion", "isClean", "defaultPreRelease", "isRelease", "releaseVersion", "markParentCommitsAsVisited", "liveBranchCount", "", "visitedCommits", "", "commits", "Ljava/util/PriorityQueue;", "Lgit/semver/plugin/semver/VersionFinder$CommitData;", "versionZero", "CommitData", "git-semver-plugin"})
@SourceDebugExtension(value={"SMAP\nVersionFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionFinder.kt\ngit/semver/plugin/semver/VersionFinder\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1313#2,2:186\n1313#2,2:201\n1603#3,9:188\n1855#3:197\n1856#3:199\n1612#3:200\n1603#3,9:203\n1855#3:212\n1856#3:214\n1612#3:215\n1#4:198\n1#4:213\n*S KotlinDebug\n*F\n+ 1 VersionFinder.kt\ngit/semver/plugin/semver/VersionFinder\n*L\n107#1:186,2\n156#1:201,2\n133#1:188,9\n133#1:197\n133#1:199\n133#1:200\n183#1:203,9\n183#1:212\n183#1:214\n183#1:215\n133#1:198\n183#1:213\n*E\n"})
public final class VersionFinder {
    @NotNull
    private final SemverSettings settings;
    @NotNull
    private final Map<String, List<IRefInfo>> tags;
    private final Logger logger;

    public VersionFinder(@NotNull SemverSettings settings, @NotNull Map<String, ? extends List<? extends IRefInfo>> tags) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.settings = settings;
        this.tags = tags;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final SemInfoVersion getVersion(@NotNull Commit commit, boolean isClean, @Nullable String defaultPreRelease) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        MutableSemVersion semVersion = VersionFinder.findVersion$default(this, commit, null, 2, null);
        boolean isModified = semVersion.getCommitCount() > 0 || !isClean;
        boolean updated = semVersion.applyPendingChanges$git_semver_plugin(isModified && !this.settings.getNoAutoBump(), this.settings.getGroupVersionIncrements());
        if (!semVersion.isPreRelease() && updated) {
            semVersion.setPreRelease$git_semver_plugin(defaultPreRelease);
        }
        return semVersion.toSemVersion();
    }

    @NotNull
    public final SemInfoVersion getReleaseVersion(@NotNull Commit commit, @Nullable String newPreRelease) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        MutableSemVersion semVersion = VersionFinder.findVersion$default(this, commit, null, 2, null);
        semVersion.setCommitCount(0);
        semVersion.applyPendingChanges$git_semver_plugin(!semVersion.isPreRelease() || !Intrinsics.areEqual((Object)"", (Object)newPreRelease), this.settings.getGroupVersionIncrements());
        if (newPreRelease != null) {
            semVersion.setPreRelease$git_semver_plugin(newPreRelease);
        }
        return semVersion.toSemVersion();
    }

    @NotNull
    public final List<Commit> getChangeLog(@NotNull Commit commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        List changeLog = new ArrayList();
        MutableSemVersion release = this.getReleaseSemVersionFromCommit(commit);
        if (this.isRelease(release)) {
            this.findVersion(commit.getParents(), (List<Commit>)changeLog);
            changeLog.add(commit);
        } else {
            this.findVersion(commit, (List<Commit>)changeLog);
        }
        return changeLog;
    }

    private final MutableSemVersion findVersion(Commit startCommit, List<Commit> changeLog) {
        if (StringsKt.isBlank((CharSequence)startCommit.getSha())) {
            return this.versionZero();
        }
        Object[] objectArray = new Commit[]{startCommit};
        return this.findVersion((Sequence<Commit>)SequencesKt.sequenceOf((Object[])objectArray), changeLog);
    }

    static /* synthetic */ MutableSemVersion findVersion$default(VersionFinder versionFinder, Commit commit, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return versionFinder.findVersion(commit, (List<Commit>)list);
    }

    /*
     * WARNING - void declaration
     */
    private final MutableSemVersion findVersion(Sequence<Commit> commitsList, List<Commit> changeLog) {
        Commit it;
        Commit currentCommit;
        CommitData commitData;
        int liveBranchCount = 1;
        MutableSemVersion lastFoundVersion = this.versionZero();
        PriorityQueue<CommitData> commits2 = new PriorityQueue<CommitData>(SequencesKt.toList((Sequence)SequencesKt.map(commitsList, (Function1)findVersion.commits.1.INSTANCE)));
        Map visitedCommits = new LinkedHashMap();
        ArrayDeque<CommitData> includedCommits = new ArrayDeque<CommitData>();
        while (!((Collection)commits2).isEmpty()) {
            commitData = (CommitData)commits2.remove();
            currentCommit = commitData.getCommit();
            if (commitData.isParentOfReleaseCommit()) {
                this.markParentCommitsAsVisited(liveBranchCount, currentCommit, visitedCommits, commits2);
                continue;
            }
            if (visitedCommits.containsKey(currentCommit.getSha())) continue;
            MutableSemVersion releaseVersion = this.getReleaseSemVersionFromCommit(currentCommit);
            visitedCommits.put(currentCommit.getSha(), releaseVersion);
            if (this.isRelease(releaseVersion)) {
                this.logger.debug("Release version found: {}", (Object)releaseVersion);
                Intrinsics.checkNotNull((Object)releaseVersion);
                this.markParentCommitsAsVisited(--liveBranchCount, currentCommit, visitedCommits, commits2);
                continue;
            }
            includedCommits.push(commitData);
            Sequence<Commit> $this$forEach$iv = currentCommit.getParents();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Commit)element$iv;
                boolean bl = false;
                commitData.getParents().add(it.getSha());
                if (visitedCommits.containsKey(it.getSha())) continue;
                commits2.add(new CommitData(it, new ArrayList(1), false));
            }
            liveBranchCount += commitData.getParents().size() - 1;
        }
        while (!((Collection)includedCommits).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            commitData = (CommitData)includedCommits.pop();
            currentCommit = commitData.getCommit();
            List<String> currentParentList = commitData.getParents();
            this.addToChangeLog(currentCommit, changeLog, currentParentList.size() > 1);
            MutableSemVersion preReleaseVersion = (MutableSemVersion)visitedCommits.get(currentCommit.getSha());
            Iterable iterable = currentParentList;
            boolean $i$f$mapNotNull = false;
            it = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                MutableSemVersion it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it2 = (String)element$iv$iv;
                boolean bl2 = false;
                if ((MutableSemVersion)visitedCommits.put(it2, null) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List parentSemVersions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            MutableSemVersion mutableSemVersion = (MutableSemVersion)CollectionsKt.maxOrNull((Iterable)parentSemVersions);
            if (mutableSemVersion == null) {
                mutableSemVersion = this.versionZero();
            }
            MutableSemVersion maxVersionFromParents = mutableSemVersion;
            maxVersionFromParents.mergeChanges$git_semver_plugin(parentSemVersions);
            maxVersionFromParents.updateFromCommit$git_semver_plugin(currentCommit, this.settings, preReleaseVersion);
            visitedCommits.put(currentCommit.getSha(), maxVersionFromParents);
            lastFoundVersion = maxVersionFromParents;
        }
        return lastFoundVersion;
    }

    private final void markParentCommitsAsVisited(int liveBranchCount, Commit currentCommit, Map<String, MutableSemVersion> visitedCommits, PriorityQueue<CommitData> commits2) {
        if (liveBranchCount == 0) {
            return;
        }
        Sequence $this$forEach$iv = SequencesKt.filter(currentCommit.getParents(), (Function1)((Function1)new Function1<Commit, Boolean>(visitedCommits){
            final /* synthetic */ Map<String, MutableSemVersion> $visitedCommits;
            {
                this.$visitedCommits = $visitedCommits;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Commit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$visitedCommits.containsKey(it.getSha());
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Commit it = (Commit)element$iv;
            boolean bl = false;
            visitedCommits.put(it.getSha(), null);
            commits2.add(new CommitData(it, new ArrayList(1), true));
        }
    }

    private final void addToChangeLog(Commit currentCommit, List<Commit> changeLog, boolean isMergeCommit) {
        block1: {
            if (isMergeCommit) {
                return;
            }
            List<Commit> list = changeLog;
            if (list == null) break block1;
            list.add(currentCommit);
        }
    }

    private final boolean isRelease(MutableSemVersion releaseVersion) {
        return releaseVersion != null && !releaseVersion.isPreRelease();
    }

    private final MutableSemVersion versionZero() {
        return new MutableSemVersion();
    }

    /*
     * WARNING - void declaration
     */
    private final MutableSemVersion getReleaseSemVersionFromCommit(Commit commit) {
        MutableSemVersion mutableSemVersion;
        if (MutableSemVersion.Companion.isRelease(commit, this.settings)) {
            mutableSemVersion = MutableSemVersion.Companion.tryParse(commit);
        } else {
            List<IRefInfo> list = this.tags.get(commit.getSha());
            if (list != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = list;
                MutableSemVersion.Companion companion = MutableSemVersion.Companion;
                boolean $i$f$mapNotNull = false;
                void var5_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    MutableSemVersion it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    IRefInfo p0 = (IRefInfo)element$iv$iv;
                    boolean bl2 = false;
                    if (companion.tryParse(p0) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                mutableSemVersion = (MutableSemVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
            } else {
                mutableSemVersion = null;
            }
        }
        return mutableSemVersion;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lgit/semver/plugin/semver/VersionFinder$CommitData;", "", "commit", "Lgit/semver/plugin/scm/Commit;", "parents", "", "", "isParentOfReleaseCommit", "", "(Lgit/semver/plugin/scm/Commit;Ljava/util/List;Z)V", "getCommit", "()Lgit/semver/plugin/scm/Commit;", "()Z", "getParents", "()Ljava/util/List;", "compareTo", "", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "git-semver-plugin"})
    public static final class CommitData
    implements Comparable<CommitData> {
        @NotNull
        private final Commit commit;
        @NotNull
        private final List<String> parents;
        private final boolean isParentOfReleaseCommit;

        public CommitData(@NotNull Commit commit, @NotNull List<String> parents, boolean isParentOfReleaseCommit) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter(parents, (String)"parents");
            this.commit = commit;
            this.parents = parents;
            this.isParentOfReleaseCommit = isParentOfReleaseCommit;
        }

        @NotNull
        public final Commit getCommit() {
            return this.commit;
        }

        @NotNull
        public final List<String> getParents() {
            return this.parents;
        }

        public final boolean isParentOfReleaseCommit() {
            return this.isParentOfReleaseCommit;
        }

        @Override
        public int compareTo(@NotNull CommitData other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((int)other.commit.getCommitTime(), (int)this.commit.getCommitTime());
        }

        @NotNull
        public final Commit component1() {
            return this.commit;
        }

        @NotNull
        public final List<String> component2() {
            return this.parents;
        }

        public final boolean component3() {
            return this.isParentOfReleaseCommit;
        }

        @NotNull
        public final CommitData copy(@NotNull Commit commit, @NotNull List<String> parents, boolean isParentOfReleaseCommit) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter(parents, (String)"parents");
            return new CommitData(commit, parents, isParentOfReleaseCommit);
        }

        public static /* synthetic */ CommitData copy$default(CommitData commitData, Commit commit, List list, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                commit = commitData.commit;
            }
            if ((n & 2) != 0) {
                list = commitData.parents;
            }
            if ((n & 4) != 0) {
                bl = commitData.isParentOfReleaseCommit;
            }
            return commitData.copy(commit, list, bl);
        }

        @NotNull
        public String toString() {
            return "CommitData(commit=" + this.commit + ", parents=" + this.parents + ", isParentOfReleaseCommit=" + this.isParentOfReleaseCommit + ')';
        }

        public int hashCode() {
            int result = this.commit.hashCode();
            result = result * 31 + ((Object)this.parents).hashCode();
            int n = this.isParentOfReleaseCommit ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitData)) {
                return false;
            }
            CommitData commitData = (CommitData)other;
            if (!Intrinsics.areEqual((Object)this.commit, (Object)commitData.commit)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parents, commitData.parents)) {
                return false;
            }
            return this.isParentOfReleaseCommit == commitData.isParentOfReleaseCommit;
        }
    }
}

