/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.pathing;

import java.io.File;

public class FileNameSeparator {
    private String path;
    private String name;
    private String extension;

    public FileNameSeparator(File fileIn) {
        if (fileIn == null) {
            this.path = "";
            this.name = "";
            this.extension = "";
        } else {
            this.path = fileIn.getParentFile().getAbsolutePath();
            this.parseFilename(fileIn.getName());
        }
    }

    public FileNameSeparator(String absoluteFile) {
        this(new File(absoluteFile == null ? "" : absoluteFile));
    }

    private void parseFilename(String filename) {
        int length;
        int index = filename.lastIndexOf(".");
        if (index == (length = filename.length()) || index == -1) {
            this.name = filename;
            this.extension = "";
        } else {
            this.name = filename.substring(0, index);
            this.extension = filename.substring(index + 1, length);
        }
    }

    public final String getPath() {
        return this.path;
    }

    public final String getName() {
        return this.name;
    }

    public final String getExtension() {
        return this.extension;
    }
}

