/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.mavenobjects;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.Artifact;

public final class ExtractSrcAftifacts {
    private static final Logger LOGGER = Logger.getLogger(ExtractSrcAftifacts.class);
    private static final int BUFFER = 2048;

    private ExtractSrcAftifacts() {
    }

    public static void extract(Set<Artifact> artifacts, String scope, File outputDirectory) throws IOException {
        Set<Artifact> filteredArtifacts = ExtractSrcAftifacts.filterArtifactList(artifacts, scope, "zip");
        ExtractSrcAftifacts.extractSet(filteredArtifacts, outputDirectory);
    }

    private static void extractSet(Set<Artifact> filteredArtifacts, File outputDirectory) throws IOException {
        for (Artifact artifact : filteredArtifacts) {
            if (!"zip".equals(artifact.getType())) continue;
            File file = artifact.getFile();
            BufferedOutputStream dest = null;
            BufferedInputStream is = null;
            ZipFile zf = new ZipFile(file);
            ZipEntry ze = null;
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                int count;
                ze = e.nextElement();
                is = new BufferedInputStream(zf.getInputStream(ze));
                byte[] data = new byte[2048];
                File newFile = new File(outputDirectory.getAbsolutePath() + File.separator + ze.getName());
                if (ze.isDirectory()) continue;
                newFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            zf.close();
        }
    }

    private static Set<Artifact> filterArtifactList(Set<Artifact> artifacts, String filterScope, String filterType) {
        LinkedHashSet<Artifact> returnArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact a : artifacts) {
            LOGGER.debug((Object)("Artifact Type: " + a.getType()));
            if (!a.getScope().equals(filterScope) || !filterType.equals(a.getType())) continue;
            returnArtifacts.add(a);
        }
        return returnArtifacts;
    }

    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory() && !srcPath.isHidden()) {
            LOGGER.debug((Object)("copying directory: " + srcPath));
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                ExtractSrcAftifacts.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else if (!srcPath.exists()) {
            LOGGER.debug((Object)("Dependency file or directory does not exist: " + srcPath));
            System.exit(0);
        } else if (!srcPath.isHidden()) {
            int len;
            LOGGER.debug((Object)("Copying file: " + srcPath));
            FileInputStream in = new FileInputStream(srcPath);
            FileOutputStream out = new FileOutputStream(dstPath);
            byte[] buf = new byte[2048];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

