/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.logging;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jOutputStream
extends OutputStream {
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private boolean isClosed = false;
    private byte[] buffer;
    private int count;
    private static final int DEFAULT_BUFFER_LENGTH = 1024;
    private final Logger logger;
    private final Level level;

    public Log4jOutputStream(Logger loggerIn, Level levelIn) {
        if (loggerIn == null || levelIn == null) {
            throw new IllegalArgumentException("nether logger nor level are allowed to be null");
        }
        this.logger = loggerIn;
        this.level = levelIn;
        this.count = 0;
        this.buffer = new byte[1024];
    }

    @Override
    public final void close() {
        this.flush();
        this.isClosed = true;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (b == 0) {
            return;
        }
        if (this.count == this.buffer.length) {
            int newBufLength = this.buffer.length + 1024;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public final void flush() {
        if (this.count == 0) {
            return;
        }
        if (this.count == LINE_SEPERATOR.length() && (char)this.buffer[0] == LINE_SEPERATOR.charAt(0) && (this.count == 1 || this.count == 2 && (char)this.buffer[1] == LINE_SEPERATOR.charAt(1))) {
            this.count = 0;
            return;
        }
        byte[] theBytes = new byte[this.count];
        System.arraycopy(this.buffer, 0, theBytes, 0, this.count);
        this.logger.log((Priority)this.level, (Object)new String(theBytes));
        this.count = 0;
    }
}

