/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.io.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class FilteredReader
extends BufferedReader {
    private final String originalString;
    private final String replacementString;
    static final int DEFAULT_BUFFER_SIZE = 8192;

    public FilteredReader(Reader in, String original, String replacement) {
        this(in, original, replacement, 8192);
    }

    public FilteredReader(Reader in, String original, String replacement, int size) {
        super(in, size);
        this.originalString = original;
        this.replacementString = replacement;
    }

    @Override
    public final String readLine() throws IOException {
        String unfiltered = super.readLine();
        if (unfiltered == null) {
            return null;
        }
        return unfiltered.replaceAll(this.originalString, this.replacementString);
    }
}

