/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.mavenutils.io;

import com.github.jlgrock.javascriptframework.mavenutils.io.DirectoryIO;
import com.github.jlgrock.javascriptframework.mavenutils.pathing.RelativeFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class ZipUtils {
    static final Logger LOGGER = Logger.getLogger(ZipUtils.class);
    private static final int BUFFER_SIZE = 1024;

    private ZipUtils() {
    }

    public static final void zipFolder(File inFolder, File destinationFile) throws IOException {
        BufferedInputStream in = null;
        byte[] data = new byte[1024];
        LOGGER.debug((Object)("starting compression of files in folder \"" + inFolder.getAbsolutePath() + "\" to resulting file \"" + destinationFile + "\"."));
        DirectoryIO.createDir(destinationFile.getParentFile());
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destinationFile)));
        Collection<RelativeFile> files = ZipUtils.buildFileList(inFolder);
        for (RelativeFile file : files) {
            int count;
            in = new BufferedInputStream(new FileInputStream(file.getFile()), 1024);
            String relFileName = file.getRelPath().equals("") ? file.getFile().getName() : file.getRelPath() + File.separator + file.getFile().getName();
            out.putNextEntry(new ZipEntry(relFileName));
            while ((count = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
            }
            out.closeEntry();
        }
        out.flush();
        out.close();
    }

    private static Collection<RelativeFile> buildFileList(File inFolder) {
        return ZipUtils.readDirectory(inFolder, "");
    }

    private static Collection<RelativeFile> readDirectory(File inFolder, String relativePath) {
        ArrayList<RelativeFile> returnCollection = new ArrayList<RelativeFile>();
        File[] files = inFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                returnCollection.addAll(ZipUtils.readDirectory(files[i], relativePath + "/" + files[i].getName()));
                continue;
            }
            if (!files[i].isFile()) continue;
            returnCollection.add(new RelativeFile(files[i], relativePath));
        }
        return returnCollection;
    }

    public static void unzip(ZipInputStream zis, File outputDir) throws IOException {
        ZipUtils.unzip(zis, null, outputDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipInputStream zis, String zipEntryName, File outputDir) throws IOException {
        ZipEntry entry = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                if (zipEntryName != null && !entry.getName().startsWith(zipEntryName)) continue;
                try {
                    ZipUtils.unzipEntry(zis, entry, outputDir);
                }
                finally {
                    zis.closeEntry();
                }
            }
        }
        finally {
            zis.close();
        }
    }

    public static void deleteDirAndUnzip(ZipInputStream zis, File outputDir) throws IOException {
        if (outputDir.exists()) {
            FileUtils.deleteDirectory((File)outputDir);
        }
        ZipUtils.unzip(zis, outputDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntry(ZipInputStream zis, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            DirectoryIO.createDir(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            DirectoryIO.createDir(outputFile.getParentFile());
        }
        BufferedInputStream inputStream = new BufferedInputStream(zis);
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }
}

