/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.limiter;

import java.time.LocalTime;
import org.repackage.com.github.jlangch.aviron.ex.AvironException;

public class CpuProfileEntry {
    private final LocalTime start;
    private final LocalTime end;
    private final int limit;

    public CpuProfileEntry(LocalTime start, LocalTime end, int limit) {
        if (start == null) {
            throw new IllegalArgumentException("A start time must not be null!");
        }
        if (end == null) {
            throw new IllegalArgumentException("An end time must not be null!");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("A limit must not be negative!");
        }
        if (start.isAfter(end)) {
            throw new IllegalArgumentException("The start time must not be after the end time!");
        }
        this.start = start;
        this.end = end;
        this.limit = limit;
    }

    public CpuProfileEntry(int startHour, int startMinute, int endHour, int endMinute, int limit) {
        this(LocalTime.of(startHour, startMinute), LocalTime.of(endHour, endMinute), limit);
    }

    public static CpuProfileEntry parse(String s) {
        try {
            String[] e = s.trim().split(" *[@:\\-%] *");
            return new CpuProfileEntry(LocalTime.of(Integer.parseInt(e[0]), Integer.parseInt(e[1])), LocalTime.of(Integer.parseInt(e[2]), Integer.parseInt(e[3])), Integer.parseInt(e[4]));
        }
        catch (Exception ex) {
            throw new AvironException("Invalid CpuProfile entry. Expected a format like \"09:00 - 15:30 @ 100%\"");
        }
    }

    public boolean isWithin(LocalTime time) {
        if (time == null) {
            throw new IllegalArgumentException("A time must not be null!");
        }
        return !time.isBefore(this.start) && !time.isAfter(this.end);
    }

    public boolean isOverlapping(CpuProfileEntry other) {
        if (other == null) {
            throw new IllegalArgumentException("A other time entry must not be null!");
        }
        if (other.getEnd().isBefore(this.start)) {
            return false;
        }
        return !other.getStart().isAfter(this.end);
    }

    public boolean isBefore(CpuProfileEntry other) {
        if (other == null) {
            throw new IllegalArgumentException("An other entry must not be null!");
        }
        return this.end.isBefore(other.getStart());
    }

    public LocalTime getStart() {
        return this.start;
    }

    public LocalTime getEnd() {
        return this.end;
    }

    public int getLimit() {
        return this.limit;
    }

    public String toString() {
        return String.format("%02d:%02d - %02d:%02d @ %d%%", this.start.getHour(), this.start.getMinute(), this.end.getHour(), this.end.getMinute(), this.limit);
    }
}

