/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.filewatcher;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FileWatcherQueue {
    public static final int QUEUE_DEFAULT_CAPACITY = 1000;
    public static final int QUEUE_MIN_CAPACITY = 5;
    public static final int QUEUE_MAX_CAPACITY = 100000;
    private final int capacity;
    private final LinkedList<File> queue = new LinkedList();
    private int overflowCount;

    public FileWatcherQueue() {
        this(1000);
    }

    public FileWatcherQueue(int capacity) {
        this.capacity = Math.max(5, Math.min(100000, capacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int capacity() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            return this.capacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(File file) {
        if (file != null) {
            LinkedList<File> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.removeIf(it -> it.equals(file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(File file) {
        if (file != null) {
            LinkedList<File> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.removeIf(it -> it.equals(file));
                if (this.queue.size() >= this.capacity) {
                    ++this.overflowCount;
                    while (this.queue.size() >= this.capacity) {
                        this.queue.removeFirst();
                    }
                }
                this.queue.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File pop() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            return this.queue.isEmpty() ? null : this.queue.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File pop(boolean existingFilesOnly) {
        if (existingFilesOnly) {
            LinkedList<File> linkedList = this.queue;
            synchronized (linkedList) {
                while (!this.queue.isEmpty()) {
                    File file = this.queue.removeFirst();
                    if (!file.exists()) continue;
                    return file;
                }
                return null;
            }
        }
        return this.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> pop(int n) {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            ArrayList<File> files = new ArrayList<File>(n);
            for (int ii = 0; ii < n && !this.queue.isEmpty(); ++ii) {
                files.add(this.queue.removeFirst());
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> pop(int n, boolean existingFilesOnly) {
        if (existingFilesOnly) {
            LinkedList<File> linkedList = this.queue;
            synchronized (linkedList) {
                ArrayList<File> files = new ArrayList<File>(n);
                while (files.size() < n && !this.queue.isEmpty()) {
                    File file = this.queue.removeFirst();
                    if (!file.exists()) continue;
                    files.add(file);
                }
                return files;
            }
        }
        return this.pop(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int overflowCount() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            return this.overflowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetOverflowCount() {
        LinkedList<File> linkedList = this.queue;
        synchronized (linkedList) {
            this.overflowCount = 0;
        }
    }
}

