/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.examples;

import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.repackage.com.github.jlangch.aviron.Clamd;
import org.repackage.com.github.jlangch.aviron.Client;
import org.repackage.com.github.jlangch.aviron.FileSeparator;
import org.repackage.com.github.jlangch.aviron.dto.ScanResult;
import org.repackage.com.github.jlangch.aviron.events.ClamdCpuLimitChangeEvent;
import org.repackage.com.github.jlangch.aviron.events.FileWatchErrorEvent;
import org.repackage.com.github.jlangch.aviron.events.QuarantineEvent;
import org.repackage.com.github.jlangch.aviron.events.QuarantineFileAction;
import org.repackage.com.github.jlangch.aviron.events.RealtimeScanEvent;
import org.repackage.com.github.jlangch.aviron.ex.AvironException;
import org.repackage.com.github.jlangch.aviron.ex.FileWatcherException;
import org.repackage.com.github.jlangch.aviron.filewatcher.FileWatcher_FsWatch;
import org.repackage.com.github.jlangch.aviron.filewatcher.FileWatcher_JavaWatchService;
import org.repackage.com.github.jlangch.aviron.filewatcher.IFileWatcher;
import org.repackage.com.github.jlangch.aviron.impl.util.CollectionUtils;
import org.repackage.com.github.jlangch.aviron.limiter.ClamdCpuLimiter;
import org.repackage.com.github.jlangch.aviron.limiter.CpuProfile;
import org.repackage.com.github.jlangch.aviron.limiter.DynamicCpuLimit;
import org.repackage.com.github.jlangch.aviron.limiter.ScheduledClamdCpuLimiter;
import org.repackage.com.github.jlangch.aviron.processor.RealtimeFileProcessor;
import org.repackage.com.github.jlangch.aviron.util.DemoFilestore;
import org.repackage.com.github.jlangch.aviron.util.OS;
import org.repackage.com.github.jlangch.aviron.util.Util;

public class RealtimeScannerExample {
    private static final boolean MOCKING = true;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private final AtomicReference<Client> client = new AtomicReference();

    public static void main(String[] args) {
        try {
            new RealtimeScannerExample().scan();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void scan() throws Exception {
        Util.printfln("Starting %s...", "in MOCKING mode ");
        try (DemoFilestore demoFS = new DemoFilestore();){
            demoFS.populateWithDemoFiles(5, 10);
            this.client.set(new Client.Builder().mocking(true).serverHostname("localhost").serverFileSeparator(FileSeparator.UNIX).quarantineFileAction(QuarantineFileAction.MOVE).quarantineDir(demoFS.getQuarantineDir()).quarantineEventListener(this::onQuarantineEvent).build());
            if (!this.client.get().waitForOperationalClamd(1L, TimeUnit.MINUTES)) {
                throw new AvironException("Clamd is not ready!");
            }
            CpuProfile everyday = CpuProfile.of("weekday", CollectionUtils.toList("00:00-05:59 @ 100%", "06:00-21:59 @  50%", "22:00-23:59 @ 100%"));
            Clamd clamd = new Clamd(demoFS.getClamdPidFile());
            ClamdCpuLimiter limiter = new ClamdCpuLimiter(clamd, new DynamicCpuLimit(everyday));
            limiter.mocking(true);
            limiter.setClamdCpuLimitChangeListener(this::onCpuLimitChangeEvent);
            Path mainDir = demoFS.getFilestoreDir().toPath();
            boolean registerAllSubDirs = true;
            IFileWatcher fw = this.createPlatformFileWatcher(mainDir, true);
            int sleepTimeSecondsOnIdle = 5;
            try (ScheduledClamdCpuLimiter ses = new ScheduledClamdCpuLimiter(limiter, 0L, 5L, TimeUnit.MINUTES);){
                ses.start();
                Util.printfln("Clamd CPU limiter started ...", new Object[0]);
                try (RealtimeFileProcessor rtScanner = new RealtimeFileProcessor(fw, 5, this::onScan, this::onErrorEvent);){
                    rtScanner.start();
                    Util.printfln("Processing ...", new Object[0]);
                    Thread.sleep(1000L);
                    demoFS.createFilestoreFile("000", "test1.data");
                    Thread.sleep(1000L);
                    demoFS.createEicarAntiMalwareTestFile("000");
                    while (!this.stop.get()) {
                        Thread.sleep(1000L);
                    }
                }
            }
        }
        Util.printfln("Stopped", new Object[0]);
    }

    private IFileWatcher createPlatformFileWatcher(Path mainDir, boolean registerAllSubDirs) {
        if (OS.isLinux()) {
            return new FileWatcher_JavaWatchService(mainDir, registerAllSubDirs);
        }
        if (OS.isMacOSX()) {
            return new FileWatcher_FsWatch(mainDir, registerAllSubDirs, null, "/opt/homebrew/bin/fswatch");
        }
        throw new FileWatcherException("FileWatcher is not supported on platforms other than Linux/MacOS!");
    }

    private void onCpuLimitChangeEvent(ClamdCpuLimitChangeEvent event) {
        Util.printfln("Adjusted %s", event);
    }

    private void onScan(RealtimeScanEvent event) {
        Util.printfln("Scanning: %s", event.getPath());
        ScanResult result = this.client.get().scan(event.getPath(), true);
        this.printVirusInfo(result);
    }

    private void onQuarantineEvent(QuarantineEvent event) {
        if (event.getException() != null) {
            Util.printfln("Quarantine error: %s", event.getException().getMessage());
        } else {
            Util.printfln("Quarantined file: %s", event.getInfectedFile());
        }
    }

    private void onErrorEvent(FileWatchErrorEvent event) {
        Util.printfln("File Watch error: %s %s", event.getPath(), event.getException().getMessage());
    }

    private void printVirusInfo(ScanResult result) {
        if (result.hasVirus()) {
            result.getVirusFound().forEach((k, v) -> Util.printfln("Virus detected: %s -> %s", CollectionUtils.first(v), k));
        }
    }
}

