/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.ipc.impl;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.util.ipc.impl.Message;
import com.github.jlangch.venice.util.ipc.impl.util.Compressor;
import com.github.jlangch.venice.util.ipc.impl.util.Encryptor;
import com.github.jlangch.venice.util.ipc.impl.util.ExceptionUtil;
import com.github.jlangch.venice.util.ipc.impl.util.IO;
import com.github.jlangch.venice.util.ipc.impl.util.PayloadMetaData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Objects;

public class Protocol {
    private static final int PROTOCOL_VERSION = 1;

    public static void sendMessage(SocketChannel ch, Message message, Compressor compressor, Encryptor encryptor) {
        Objects.requireNonNull(ch);
        Objects.requireNonNull(message);
        boolean isCompressData = compressor.needsCompression(message.getData());
        ByteBuffer header = ByteBuffer.allocate(18);
        header.put((byte)118);
        header.put((byte)110);
        header.putInt(1);
        header.putShort(Protocol.toShort(isCompressData));
        header.putShort(Protocol.toShort(encryptor.isActive()));
        header.putLong(message.getTimestamp());
        header.flip();
        IO.writeFully(ch, header);
        byte[] headerAAD = header.array();
        byte[] metaData = encryptor.encrypt(PayloadMetaData.encode(new PayloadMetaData(message)), headerAAD);
        ByteBuffer meta = ByteBuffer.allocate(metaData.length);
        meta.put(metaData);
        meta.flip();
        IO.writeFrame(ch, meta);
        byte[] payloadData = encryptor.encrypt(compressor.compress(message.getData(), isCompressData));
        ByteBuffer payload = ByteBuffer.allocate(payloadData.length);
        payload.put(payloadData);
        payload.flip();
        IO.writeFrame(ch, payload);
    }

    public static Message receiveMessage(SocketChannel ch, Compressor compressor, Encryptor encryptor) {
        Objects.requireNonNull(ch);
        try {
            ByteBuffer header = ByteBuffer.allocate(18);
            int bytesRead = ch.read(header);
            if (bytesRead < 0) {
                throw new EofException("Failed to read data from channel, channel EOF reached!");
            }
            header.flip();
            byte magic1 = header.get();
            byte magic2 = header.get();
            int version = header.getInt();
            boolean isCompressedData = Protocol.toBool(header.getShort());
            boolean isEncryptedData = Protocol.toBool(header.getShort());
            long timestamp = header.getLong();
            if (magic1 != 118 || magic2 != 110) {
                throw new VncException("Received unknown message (bad magic bytes)!");
            }
            if (version != 1) {
                throw new VncException("Received message with unsupported protocol version " + version + "!");
            }
            ByteBuffer payloadMetaFrame = IO.readFrame(ch);
            byte[] headerAAD = header.array();
            PayloadMetaData payloadMeta = PayloadMetaData.decode(encryptor.decrypt(payloadMetaFrame.array(), headerAAD, isEncryptedData));
            ByteBuffer payloadFrame = IO.readFrame(ch);
            byte[] payloadData = compressor.decompress(encryptor.decrypt(payloadFrame.array(), isEncryptedData), isCompressedData);
            return new Message(payloadMeta.getId(), payloadMeta.getType(), payloadMeta.getResponseStatus(), payloadMeta.isOneway(), payloadMeta.getQueueName(), timestamp, payloadMeta.getTopics(), payloadMeta.getMimetype(), payloadMeta.getCharset(), payloadData);
        }
        catch (IOException ex) {
            if (ExceptionUtil.isBrokenPipeException(ex)) {
                throw new VncException("Failed to read data from channel, channel was closed!", ex);
            }
            throw new VncException("Failed to read data from channel!", ex);
        }
    }

    private static boolean toBool(int n) {
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        throw new VncException("Illegal IPC message boolean value");
    }

    private static short toShort(boolean b) {
        return b ? (short)1 : 0;
    }
}

