/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.dh;

import com.github.jlangch.venice.util.dh.DiffieHellmanSharedSecret;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.KeyAgreement;

public class DiffieHellmanKeys {
    private final KeyPair keyPair;

    private DiffieHellmanKeys(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public static DiffieHellmanKeys create() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DiffieHellman");
            keyPairGenerator.initialize(2048);
            return new DiffieHellmanKeys(keyPairGenerator.generateKeyPair());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Failed to create Diffie-Hellman keys", ex);
        }
    }

    public DiffieHellmanSharedSecret generateSharedSecret(String otherPartyPublicKey) {
        try {
            byte[] publicKeyBytes = Base64.getDecoder().decode(otherPartyPublicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            KeyAgreement keyAgreement = KeyAgreement.getInstance("DiffieHellman");
            keyAgreement.init(this.keyPair.getPrivate());
            keyAgreement.doPhase(publicKey, true);
            return new DiffieHellmanSharedSecret(keyAgreement.generateSecret());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create Diffie-Hellman shared secret", ex);
        }
    }

    public String getPublicKeyBase64() {
        byte[] key = this.keyPair.getPublic().getEncoded();
        return Base64.getEncoder().encodeToString(key);
    }
}

