/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util.crypt;

import com.github.jlangch.venice.FileException;
import com.github.jlangch.venice.util.Base64Schema;
import com.github.jlangch.venice.util.crypt.IEncryptor;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Base64;
import java.util.Objects;

public abstract class AbstractEncryptor
implements IEncryptor {
    @Override
    public abstract byte[] encrypt(byte[] var1);

    @Override
    public abstract byte[] decrypt(byte[] var1);

    @Override
    public byte[] encrypt(byte[] data, byte[] aad) {
        throw new RuntimeException("Encryption with  AAD (authenticated additional data) is  not supported by this encryptor!");
    }

    @Override
    public byte[] decrypt(byte[] data, byte[] aad) {
        throw new RuntimeException("Encryption with  AAD (authenticated additional data) is  not supported by this encryptor!");
    }

    @Override
    public String encrypt(String text, Base64Schema schema) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(schema);
        byte[] encryptedBytes = this.encrypt(text.getBytes(StandardCharsets.UTF_8));
        return new String(this.encoder(schema).encode(encryptedBytes), StandardCharsets.UTF_8);
    }

    @Override
    public String decrypt(String base64, Base64Schema schema) {
        Objects.requireNonNull(base64);
        Objects.requireNonNull(schema);
        byte[] encryptedBytes = this.decoder(schema).decode(base64.getBytes(StandardCharsets.UTF_8));
        byte[] decryptedBytes = this.decrypt(encryptedBytes);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    @Override
    public void encrypt(File inputFile, File outputFile, boolean overwrite) {
        Objects.requireNonNull(inputFile);
        Objects.requireNonNull(outputFile);
        try {
            byte[] data = Files.readAllBytes(inputFile.toPath());
            Files.write(outputFile.toPath(), this.encrypt(data), this.getOpenOptions(overwrite));
        }
        catch (Exception ex) {
            throw new FileException("Failed to encrypt file " + inputFile, ex);
        }
    }

    @Override
    public void decrypt(File inputFile, File outputFile, boolean overwrite) {
        Objects.requireNonNull(inputFile);
        Objects.requireNonNull(outputFile);
        try {
            byte[] data = Files.readAllBytes(inputFile.toPath());
            Files.write(outputFile.toPath(), this.decrypt(data), this.getOpenOptions(overwrite));
        }
        catch (Exception ex) {
            throw new FileException("Failed to decrypt file " + inputFile, ex);
        }
    }

    private Base64.Encoder encoder(Base64Schema scheme) {
        switch (scheme) {
            case Standard: {
                return Base64.getEncoder();
            }
            case UrlSafe: {
                return Base64.getUrlEncoder();
            }
        }
        throw new IllegalArgumentException("Invalid Base64 scheme '" + scheme.name() + "'");
    }

    private Base64.Decoder decoder(Base64Schema scheme) {
        switch (scheme) {
            case Standard: {
                return Base64.getDecoder();
            }
            case UrlSafe: {
                return Base64.getUrlDecoder();
            }
        }
        throw new IllegalArgumentException("Invalid Base64 scheme '" + scheme.name() + "'");
    }

    private OpenOption[] getOpenOptions(boolean overwrite) {
        OpenOption[] openOptionArray;
        if (overwrite) {
            OpenOption[] openOptionArray2 = new OpenOption[3];
            openOptionArray2[0] = StandardOpenOption.WRITE;
            openOptionArray2[1] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray2;
            openOptionArray2[2] = StandardOpenOption.TRUNCATE_EXISTING;
        } else {
            OpenOption[] openOptionArray3 = new OpenOption[2];
            openOptionArray3[0] = StandardOpenOption.WRITE;
            openOptionArray = openOptionArray3;
            openOptionArray3[1] = StandardOpenOption.CREATE_NEW;
        }
        return openOptionArray;
    }
}

