/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class StopWatch {
    private AtomicLong startTime = new AtomicLong(0L);
    private AtomicLong elapsedTime = new AtomicLong(0L);
    private AtomicLong limitTime = new AtomicLong(0L);

    public StopWatch() {
        this(System.currentTimeMillis(), 0L, 0L);
    }

    public StopWatch(TimeUnit unit, long n) {
        this(System.currentTimeMillis(), 0L, unit == null ? n : TimeUnit.MILLISECONDS.convert(n, unit));
    }

    private StopWatch(long startTime, long elapsedTime, long limitMilliseconds) {
        this.startTime = new AtomicLong(startTime);
        this.elapsedTime = new AtomicLong(elapsedTime);
        this.limitTime = new AtomicLong(startTime + limitMilliseconds);
    }

    public StopWatch copy() {
        return new StopWatch(this.startTime.get(), this.elapsedTime.get(), this.limitTime.get());
    }

    public StopWatch start() {
        this.startTime = new AtomicLong(System.currentTimeMillis());
        this.elapsedTime = new AtomicLong(0L);
        return this;
    }

    public StopWatch resume() {
        this.startTime = new AtomicLong(System.currentTimeMillis());
        return this;
    }

    public StopWatch stop() {
        this.elapsedTime.addAndGet(this.splitTime());
        this.startTime = new AtomicLong(System.currentTimeMillis());
        return this;
    }

    public long elapsed(TimeUnit unit) {
        return unit == null ? this.elapsedTime.get() : unit.convert(this.elapsedTime.get(), TimeUnit.MILLISECONDS);
    }

    public long elapsedMillis() {
        return this.elapsedTime.get();
    }

    public long splitTime(TimeUnit unit) {
        return unit == null ? this.splitTime() : unit.convert(this.splitTime(), TimeUnit.MILLISECONDS);
    }

    public long splitTime() {
        return Math.max(0L, System.currentTimeMillis() - this.startTime.get());
    }

    public String elapsedMillisFormatted() {
        return StopWatch.formatMillis(this.elapsedTime.get());
    }

    public boolean hasExpired() {
        long limit = this.limitTime.get();
        return limit == 0L ? false : System.currentTimeMillis() > limit;
    }

    public String toString() {
        return StopWatch.formatMillis(this.elapsedTime.get());
    }

    public static String formatMillis(long millis) {
        if (millis < 1000L) {
            return String.format("%dms", millis);
        }
        if (millis < 60000L) {
            return String.format("%ds %dms", millis / 1000L, millis % 1000L);
        }
        long seconds = millis / 1000L;
        return String.format("%dm %ds", seconds / 60L, seconds % 60L);
    }
}

