/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.shell;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.shell.ShellBackgroundResult;
import com.github.jlangch.venice.impl.util.shell.ShellResult;
import com.github.jlangch.venice.impl.util.shell.Signal;
import com.github.jlangch.venice.util.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleShell {
    public static ShellResult execCmd(String ... command) {
        String cmdFormatted = SimpleShell.formatCmd(command);
        try {
            Process proc = Runtime.getRuntime().exec(command);
            return SimpleShell.getShellResult(proc);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to run command: " + cmdFormatted, ex);
        }
    }

    public static ShellBackgroundResult execCmdBackground(String ... command) {
        SimpleShell.validateLinuxOrMacOSX("Shell::execCmdBackground");
        String cmdFormatted = SimpleShell.formatCmd(command);
        try {
            File nohup = File.createTempFile("nohup-", ".out");
            nohup.deleteOnExit();
            String cmd = cmdFormatted + " 2>&1 >" + nohup.getAbsolutePath() + " &";
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            return new ShellBackgroundResult(SimpleShell.getShellResult(proc), nohup);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to run nohup command: /bin/sh -c " + cmdFormatted + " 2>&1 >nohup.out &", ex);
        }
    }

    public static ShellBackgroundResult execCmdBackgroundNohup(String ... command) throws IOException {
        SimpleShell.validateLinuxOrMacOSX("Shell::execCmdNohup");
        String cmdFormatted = SimpleShell.formatCmd(command);
        try {
            File nohup = File.createTempFile("nohup-", ".out");
            nohup.deleteOnExit();
            String cmd = "nohup " + cmdFormatted + " 2>&1 >" + nohup.getAbsolutePath() + " &";
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            return new ShellBackgroundResult(SimpleShell.getShellResult(proc), nohup);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to run nohup command: /bin/sh -c nohup " + cmdFormatted + " 2>&1 >nohup.out &", ex);
        }
    }

    public static List<String> pgrep(String process) {
        SimpleShell.validateLinuxOrMacOSX("Shell::pgrep");
        ShellResult r = SimpleShell.execCmd("pgrep", "-x", process);
        return r.isZeroExitCode() ? r.getStdoutLines().stream().filter(s -> !StringUtil.isBlank(s)).collect(Collectors.toList()) : new ArrayList<String>();
    }

    public static void pkill(String process, Signal signal) {
        SimpleShell.validateLinuxOrMacOSX("Shell::pkill");
        Signal sig = signal == null ? Signal.SIGTERM : signal;
        ShellResult r = SimpleShell.execCmd("pkill", "-" + sig.signal(), "-x", process);
        if (!r.isZeroExitCode()) {
            throw new RuntimeException("Failed to kill process (" + process + ").\n\nExit code: " + r.getExitCode() + "\nError msg: " + r.getStderr());
        }
    }

    public static String pargs(String pid) {
        SimpleShell.validateLinuxOrMacOSX("Shell::pargs");
        ShellResult r = SimpleShell.execCmd("ps", "-p", pid, "-ww", "-o", "args");
        if (r.isZeroExitCode()) {
            List<String> lines = r.getStdoutLines();
            return lines.size() == 2 ? lines.get(1) : null;
        }
        return null;
    }

    public static void kill(String pid, Signal signal) {
        SimpleShell.validateLinuxOrMacOSX("Shell::kill");
        if (!StringUtil.isBlank(pid)) {
            Signal sig = signal == null ? Signal.SIGTERM : signal;
            ShellResult r = SimpleShell.execCmd("kill", "-" + sig.signal(), pid);
            if (!r.isZeroExitCode()) {
                throw new RuntimeException("Failed to kill process (" + pid + "), signal=" + (Object)((Object)sig) + ".\n\nExit code: " + r.getExitCode() + "\nError msg: " + r.getStderr());
            }
        }
    }

    public static void killall(String process, Signal signal) {
        SimpleShell.validateLinuxOrMacOSX("Shell::killall");
        if (!StringUtil.isBlank(process)) {
            Signal sig = signal == null ? Signal.SIGTERM : signal;
            ShellResult r = SimpleShell.execCmd("killall", "-" + sig.signal(), "-e", process);
            if (!r.isZeroExitCode()) {
                throw new RuntimeException("Failed to kill all processes with the name='" + process + "', signal=" + (Object)((Object)sig) + ".\n\nExit code: " + r.getExitCode() + "\nError msg: " + r.getStderr());
            }
        }
    }

    public static String which(String program) {
        ShellResult r;
        SimpleShell.validateLinuxOrMacOSX("Shell::which");
        if (!StringUtil.isBlank(program) && (r = SimpleShell.execCmd("/bin/sh", "-c", "which " + program)).isZeroExitCode()) {
            return r.getStdoutLines().stream().findFirst().orElse(null);
        }
        return null;
    }

    public static void validateLinuxOrMacOSX(String fnName) {
        if (!OS.isLinux() && !OS.isMacOSX()) {
            throw new RuntimeException(fnName + " is available for Linux and MacOS only!");
        }
    }

    private static String formatCmd(String ... command) {
        return String.join((CharSequence)" ", Arrays.asList(command));
    }

    private static String slurp(InputStream is) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String string = br.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static ShellResult getShellResult(Process proc) throws IOException, InterruptedException {
        int exitCode = proc.waitFor();
        String stdout = SimpleShell.slurp(proc.getInputStream());
        String stderr = SimpleShell.slurp(proc.getErrorStream());
        return new ShellResult(stdout, stderr, exitCode);
    }
}

