/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.shell;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.List;

public class ShellResult {
    private final String stdout;
    private final String stderr;
    private final int exitCode;

    public ShellResult(String stdout, String stderr, int exitCode) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.exitCode = exitCode;
    }

    public String getStdout() {
        return this.stdout;
    }

    public List<String> getStdoutLines() {
        return StringUtil.splitIntoLines(this.stdout);
    }

    public String getStderr() {
        return this.stderr;
    }

    public List<String> getStderrLines() {
        return StringUtil.splitIntoLines(this.stderr);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isZeroExitCode() {
        return this.exitCode == 0;
    }

    public String toString() {
        String err = StringUtil.trimToNull(this.stderr);
        String out = StringUtil.trimToNull(this.stdout);
        StringBuilder sb = new StringBuilder();
        sb.append("Exit code: " + this.exitCode);
        if (out == null) {
            sb.append("\n[stdout]  empty\n");
        } else {
            sb.append("\n[stdout]\n");
            sb.append(out);
        }
        if (err == null) {
            sb.append("\n[stderr]  empty\n");
        } else {
            sb.append("\n[stderr]\n");
            sb.append(err);
        }
        return sb.toString();
    }
}

