/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.SymbolMapBuilder;
import com.github.jlangch.venice.impl.util.jar.AutoRunScriptJarRewriter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class CoreSystemFunctions {
    public static VncFunction version = new VncFunction("version", (VncVal)VncFunction.meta().arglists("(version)").doc("Returns the Venice version.").examples("(version)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(Version.VERSION);
        }
    };
    public static VncFunction uuid = new VncFunction("uuid", (VncVal)VncFunction.meta().arglists("(uuid)").doc("Generates a UUID.").examples("(uuid)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(UUID.randomUUID().toString());
        }
    };
    public static VncFunction objid = new VncFunction("objid", (VncVal)VncFunction.meta().arglists("(objid)").doc("Returns the original unique hash code for the given object.").examples("(objid x)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return new VncLong(System.identityHashCode(args.first()));
        }
    };
    public static VncFunction current_time_millis = new VncFunction("current-time-millis", (VncVal)VncFunction.meta().arglists("(current-time-millis)").doc("Returns the current time in milliseconds.").examples("(current-time-millis)").seeAlso("nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(System.currentTimeMillis());
        }
    };
    public static VncFunction nano_time = new VncFunction("nano-time", (VncVal)VncFunction.meta().arglists("(nano-time)").doc("Returns the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds.").examples("(nano-time)", "(let [t (nano-time)                        \n      _ (sleep 100)                        \n      e (nano-time)]                       \n  (format-nano-time (- e t) :precision 2))  ").seeAlso("current-time-millis", "format-nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncLong(System.nanoTime());
        }
    };
    public static VncFunction format_milli_time = new VncFunction("format-milli-time", (VncVal)VncFunction.meta().arglists("(format-milli-time time)", "(format-milli-time time & options)").doc("Formats a time given in milliseconds as long or double. \n\nOptions: \n\n| :precision p | e.g :precision 4 (defaults to 3)|\n").examples("(format-milli-time 203)", "(format-milli-time 20389.0 :precision 2)", "(format-milli-time 20389 :precision 2)", "(format-milli-time 20389 :precision 0)").seeAlso("format-micro-time", "format-nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            long time;
            ArityExceptions.assertMinArity(this, args, 1);
            VncVal val = args.first();
            if ((Types.isVncLong(val) || Types.isVncInteger(val)) && (time = VncLong.of(val).getValue().longValue()) < 1000L) {
                return new VncString(String.format("%dms", time));
            }
            VncHashMap options = VncHashMap.ofAll(args.rest());
            int precision = Coerce.toVncLong(options.get(new VncKeyword("precision"), new VncLong(3L))).getIntValue();
            double time2 = VncDouble.of(val).getValue();
            String unit = "s";
            double scale = 1000.0;
            if (time2 < 1000.0) {
                unit = "ms";
                scale = 1.0;
            }
            return new VncString(String.format("%." + precision + "f" + unit, time2 / scale));
        }
    };
    public static VncFunction format_micro_time = new VncFunction("format-micro-time", (VncVal)VncFunction.meta().arglists("(format-micro-time time)", "(format-micro-time time & options)").doc("Formats a time given in microseconds as long or double. \n\nOptions: \n\n| :precision p | e.g :precision 4 (defaults to 3)|").examples("(format-micro-time 203)", "(format-micro-time 20389.0 :precision 2)", "(format-micro-time 20389 :precision 2)", "(format-micro-time 20389 :precision 0)", "(format-micro-time 20386766)", "(format-micro-time 20386766 :precision 2)", "(format-micro-time 20386766 :precision 6)").seeAlso("format-milli-time", "format-nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            long time;
            ArityExceptions.assertMinArity(this, args, 1);
            VncVal val = args.first();
            if ((Types.isVncLong(val) || Types.isVncInteger(val)) && (time = VncLong.of(val).getValue().longValue()) < 1000L) {
                return new VncString(String.format("%d\u00b5s", time));
            }
            VncHashMap options = VncHashMap.ofAll(args.rest());
            int precision = Coerce.toVncLong(options.get(new VncKeyword("precision"), new VncLong(3L))).getIntValue();
            double time2 = VncDouble.of(val).getValue();
            String unit = "s";
            double scale = 1000000.0;
            if (time2 < 1000.0) {
                unit = "\u00b5s";
                scale = 1.0;
            } else if (time2 < 1000000.0) {
                unit = "ms";
                scale = 1000000.0;
            }
            return new VncString(String.format("%." + precision + "f" + unit, time2 / scale));
        }
    };
    public static VncFunction format_nano_time = new VncFunction("format-nano-time", (VncVal)VncFunction.meta().arglists("(format-nano-time time)", "(format-nano-time time & options)").doc("Formats a time given in nanoseconds as long or double. \n\nOptions: \n\n| :precision p | e.g :precision 4 (defaults to 3)|").examples("(format-nano-time 203)", "(format-nano-time 20389.0 :precision 2)", "(format-nano-time 20389 :precision 2)", "(format-nano-time 20389 :precision 0)", "(format-nano-time 203867669)", "(format-nano-time 20386766988 :precision 2)", "(format-nano-time 20386766988 :precision 6)").seeAlso("format-milli-time", "format-micro-time", "nano-time").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            long time;
            ArityExceptions.assertMinArity(this, args, 1);
            VncVal val = args.first();
            if ((Types.isVncLong(val) || Types.isVncInteger(val)) && (time = VncLong.of(val).getValue().longValue()) < 1000L) {
                return new VncString(String.format("%dns", time));
            }
            VncHashMap options = VncHashMap.ofAll(args.rest());
            int precision = Coerce.toVncLong(options.get(new VncKeyword("precision"), new VncLong(3L))).getIntValue();
            double time2 = VncDouble.of(val).getValue();
            String unit = "s";
            double scale = 1.0E9;
            if (time2 < 1000.0) {
                unit = "ns";
                scale = 1.0;
            } else if (time2 < 1000000.0) {
                unit = "\u00b5s";
                scale = 1000.0;
            } else if (time2 < 1.0E9) {
                unit = "ms";
                scale = 1000000.0;
            }
            return new VncString(String.format("%." + precision + "f" + unit, time2 / scale));
        }
    };
    public static VncFunction sleep = new VncFunction("sleep", (VncVal)VncFunction.meta().arglists("(sleep n)", "(sleep n time-unit)").doc("Sleep for the time n. The default time unit is milliseconds.\u00b6Time unit is one of :milliseconds, :seconds, :minutes, :hours, or :days or their abbreviations :msec, :ms, :sec, :s, :min, :hr, :h, :d.").examples("(sleep 30)", "(sleep 30 :milliseconds)", "(sleep 30 :msec)", "(sleep 5 :seconds)", "(sleep 5 :sec)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            try {
                long sleep = Coerce.toVncLong(args.first()).getValue();
                TimeUnit unit = args.size() == 1 ? TimeUnit.MILLISECONDS : CoreSystemFunctions.toTimeUnit(Coerce.toVncKeyword(args.second()));
                Thread.sleep(unit.toMillis(Math.max(0L, sleep)));
            }
            catch (java.lang.InterruptedException ex) {
                throw new InterruptedException("interrupted while calling (sleep n)", ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction charset_default_encoding = new VncFunction("charset-default-encoding", (VncVal)VncFunction.meta().arglists("(charset-default-encoding)").doc("Returns the default charset of this Java virtual machine.").examples("(charset-default-encoding)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncKeyword(Charset.defaultCharset().name());
        }
    };
    public static VncFunction auto_run_jar = new VncFunction("auto-run-jar", (VncVal)VncFunction.meta().arglists("(auto-run-jar script-name script-version script save-to)").doc("Turns any standalone Venice script into an executable Venice JAR.\n\nThe `auto-run-jar` command takes a Venice JAR and copies it to a new JAR with a modified JAR manifest that executes the script when running the JAR with: `java -jar xxxx.jar`\n\nThe created JAR name will be: {script-name}.jar \n\nThe command line parameters will be available as `*ARGV*` list in the script.").examples(";; run the created JAR:  java -jar {path-to-jar}/example.jar  \n(let [script         \"\"\"(println \"sum:\" (+ 1 2))\"\"\"   \n      script-name    \"example\"                              \n      script-version \"1.0\"                                  \n      dir            \".\" ]                                  \n  (auto-run-jar script-name script-version script dir))       ", ";; run the created JAR:  java -jar {path-to-jar}/example.jar 1 2 \n(let [script         \"\"\"\n                     (println \"sum:\" (+ (long (first *ARGV*)) \n                                        (long (second *ARGV*)))) \n                     \"\"\"] \n      script-name    \"example\"                              \n      script-version \"1.0\"                                  \n      dir            \".\" ]                                  \n  (auto-run-jar script-name script-version script dir))                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 4);
            byte[] existingVeniceJar = null;
            String scriptName = Coerce.toVncString(args.first()).getValue();
            String scriptVersion = Coerce.toVncString(args.second()).getValue();
            String script = Coerce.toVncString(args.third()).getValue();
            Path saveTo = CoreSystemFunctions.convertToPath(args.fourth());
            return new VncJavaObject(AutoRunScriptJarRewriter.createAndSaveAutoRunVeniceJar(existingVeniceJar, scriptName, scriptVersion, script, saveTo));
        }
    };
    public static final Map<VncVal, VncVal> ns = new SymbolMapBuilder().add(uuid).add(objid).add(current_time_millis).add(nano_time).add(format_nano_time).add(format_micro_time).add(format_milli_time).add(sleep).add(version).add(charset_default_encoding).add(auto_run_jar).toMap();
    public static final VncKeyword CALLSTACK_KEY_FN_NAME = new VncKeyword(":fn-name");
    public static final VncKeyword CALLSTACK_KEY_FILE = new VncKeyword(":file");
    public static final VncKeyword CALLSTACK_KEY_LINE = new VncKeyword(":line");
    public static final VncKeyword CALLSTACK_KEY_COL = new VncKeyword(":col");
    public static final AtomicInteger SYSTEM_EXIT_CODE = new AtomicInteger(0);

    private static TimeUnit toTimeUnit(VncKeyword unit) {
        switch (unit.getValue()) {
            case "milliseconds": 
            case "msec": 
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "seconds": 
            case "sec": 
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "minutes": 
            case "min": {
                return TimeUnit.MINUTES;
            }
            case "hours": 
            case "hr": 
            case "h": {
                return TimeUnit.HOURS;
            }
            case "days": 
            case "d": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid scheduler time-unit " + unit.toString() + ". Use one of {:milliseconds, :seconds, :minutes, :hours, :days} or the abbreviations {:msec, :ms, :sec, :s, :min, :hr, :h, :d}");
    }

    private static Path convertToPath(VncVal f) {
        if (Types.isVncString(f)) {
            return new File(((VncString)f).getValue()).toPath();
        }
        if (Types.isVncJavaObject(f, File.class)) {
            return Coerce.toVncJavaObject(f, File.class).toPath();
        }
        if (Types.isVncJavaObject(f, Path.class)) {
            return Coerce.toVncJavaObject(f, Path.class);
        }
        return null;
    }
}

