/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.IServiceDiscovery;
import com.github.jlangch.venice.IServiceRegistry;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ServiceRegistry
implements IServiceRegistry {
    private Map<String, Object> staticRegistry = new ConcurrentHashMap<String, Object>();
    private AtomicReference<IServiceDiscovery> serviceDiscovery = new AtomicReference();

    public ServiceRegistry() {
        this.clear();
    }

    @Override
    public ServiceRegistry register(String name, Object service) {
        if (StringUtil.isBlank(name)) {
            throw new AssertionException("A service name for the service registry must not be blank!");
        }
        if (service == null) {
            throw new AssertionException("A service for the service registry must not be null!");
        }
        this.staticRegistry.put(name, service);
        return this;
    }

    @Override
    public ServiceRegistry registerAll(Map<String, Object> services) {
        if (services != null) {
            services.forEach((k, v) -> this.register((String)k, v));
        }
        return this;
    }

    @Override
    public ServiceRegistry registerServiceDiscovery(IServiceDiscovery serviceDiscovery) {
        if (serviceDiscovery == null) {
            throw new AssertionException("A service discovery for the service registry must not be null!");
        }
        this.serviceDiscovery.set(serviceDiscovery);
        return this;
    }

    @Override
    public ServiceRegistry unregister(String name) {
        if (name == null) {
            throw new AssertionException("A service name for unregistering a service in the service registry must not be null!");
        }
        this.staticRegistry.remove(name);
        return this;
    }

    @Override
    public ServiceRegistry unregisterAll() {
        this.clear();
        return this;
    }

    @Override
    public ServiceRegistry unregisterServiceDiscovery() {
        this.serviceDiscovery.set(null);
        return this;
    }

    @Override
    public Object lookup(String name) {
        if (name == null) {
            throw new AssertionException("A service name for looking up a service in the service registry must not be null!");
        }
        Object service = this.staticRegistry.get(name);
        if (service != null) {
            return service;
        }
        IServiceDiscovery sd = this.serviceDiscovery.get();
        if (sd != null) {
            return sd.lookup(name);
        }
        throw new VncException("No registered service available under the name '" + name + "'!");
    }

    @Override
    public boolean exists(String name) {
        if (name == null) {
            throw new AssertionException("A service name for checking service availability in the service registry must not be null!");
        }
        if (this.staticRegistry.containsKey(name)) {
            return true;
        }
        IServiceDiscovery sd = this.serviceDiscovery.get();
        return sd != null && sd.exists(name);
    }

    private void clear() {
        this.staticRegistry.clear();
        this.serviceDiscovery.set(null);
    }
}

