/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.IVeniceInterpreter;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.util.CollectionUtil;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class AutoRunScriptLauncher {
    public static void main(String[] args) {
        int exitCode = AutoRunScriptLauncher.run(args);
        System.exit(exitCode);
    }

    public static int run(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        try {
            VeniceInterpreter venice = new VeniceInterpreter(new AcceptAllInterceptor());
            String script = AutoRunScriptLauncher.loadAutoRunScript();
            String scriptName = AutoRunScriptLauncher.loadAutoRunScriptName();
            Env env = AutoRunScriptLauncher.createEnv(venice, true, RunMode.SCRIPT, Arrays.asList(AutoRunScriptLauncher.convertCliArgsToVar(cli)));
            venice.PRINT(venice.RE(script, scriptName, env));
            return SystemFunctions.SYSTEM_EXIT_CODE.get();
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
            return 99;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 99;
        }
    }

    private static Env createEnv(IVeniceInterpreter venice, boolean macroexpand, RunMode runMode, List<Var> vars) {
        return venice.createEnv(macroexpand, false, runMode).addGlobalVars(vars).setStdoutPrintStream(new PrintStream(System.out, true)).setStderrPrintStream(new PrintStream(System.err, true)).setStdinReader(new InputStreamReader(System.in));
    }

    private static String loadAutoRunScript() {
        String script = new ClassPathResource("com/github/jlangch/venice/auto/autorun.venice").getResourceAsString("UTF-8");
        if (script == null) {
            throw new VncException("Failed to load embedded auto run script!");
        }
        return script;
    }

    private static String loadAutoRunScriptName() {
        try {
            String data = new ClassPathResource("com/github/jlangch/venice/auto/autorun.meta").getResourceAsString("UTF-8");
            String line = StringUtil.trimToEmpty(CollectionUtil.first(StringUtil.splitIntoLines(data)));
            String name = StringUtil.trimToNull(line.split("=")[1]);
            return name == null ? "autorun" : name;
        }
        catch (Exception ex) {
            return "autorun";
        }
    }

    private static Var convertCliArgsToVar(CommandLineArgs cli) {
        return new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false, Var.Scope.Global);
    }
}

