/*   __    __         _
 *   \ \  / /__ _ __ (_) ___ ___
 *    \ \/ / _ \ '_ \| |/ __/ _ \
 *     \  /  __/ | | | | (_|  __/
 *      \/ \___|_| |_|_|\___\___|
 *
 *
 * Copyright 2017-2025 Venice
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.jlangch.venice.impl.docgen.cheatsheet.modules;

import com.github.jlangch.venice.impl.docgen.cheatsheet.DocItemBuilder;
import com.github.jlangch.venice.impl.docgen.cheatsheet.DocSection;
import com.github.jlangch.venice.impl.docgen.cheatsheet.ISectionBuilder;


public class ModuleCargoSection implements ISectionBuilder {

    public ModuleCargoSection(final DocItemBuilder diBuilder) {
        this.diBuilder = diBuilder;
    }

    @Override
    public DocSection section() {
        final DocSection section = new DocSection(
                                        "Cargo",
                                        "Docker Testcontainers",
                                        "modules.cargo",
                                        "Greatly simplifies starting/stopping docker containers. " +
                                        "Depending on the state of the container pulls a new image, " +
                                        "starts or runs the container and checks the logs if it has " +
                                        "successfully started up, all this in one single command.\n\n" +
                                        "It's the base module for cargo modules like Cargo/ArangoDB, " +
                                        "Cargo/PostgreSQL, and Cargo/Qdrant.",
                                        null);

        final DocSection all = new DocSection("(load-module :cargo)", id());
        section.addSection(all);

        final DocSection docker = new DocSection("Cargo", id());
        all.addSection(docker);
        docker.addItem(diBuilder.getDocItem("cargo/start", false));
        docker.addItem(diBuilder.getDocItem("cargo/stop", false));
        docker.addItem(diBuilder.getDocItem("cargo/running?", false));
        docker.addItem(diBuilder.getDocItem("cargo/purge", false));

        return section;
    }

    private String id() {
        return diBuilder.id();
    }

    private final DocItemBuilder diBuilder;
}
