/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.util.service;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.repackage.com.github.jlangch.aviron.util.service.IService;
import org.repackage.com.github.jlangch.aviron.util.service.ServiceStatus;

public abstract class Service
implements IService,
Closeable {
    private static final AtomicLong threadCounter = new AtomicLong(1L);
    private final AtomicReference<ServiceStatus> status = new AtomicReference<ServiceStatus>(ServiceStatus.CREATED);

    protected abstract String name();

    protected abstract void onStart();

    protected abstract void onClose() throws IOException;

    @Override
    public final void start() {
        if (this.status.compareAndSet(ServiceStatus.CREATED, ServiceStatus.INITIALISING)) {
            try {
                this.onStart();
            }
            catch (Exception ex) {
                this.status.set(ServiceStatus.CLOSED);
                throw new RuntimeException("Failed to start the service '" + this.name() + "'!", ex);
            }
        } else {
            throw new RuntimeException("Rejected to start the service '" + this.name() + "'. The service is in status " + (Object)((Object)this.status.get()));
        }
    }

    @Override
    public final void close() {
        if (this.status.compareAndSet(ServiceStatus.RUNNING, ServiceStatus.CLOSED)) {
            try {
                this.onClose();
            }
            catch (Exception ex) {
                this.status.set(ServiceStatus.CLOSED);
                throw new RuntimeException("Failed to close the service '" + this.name() + "'!", ex);
            }
        } else {
            throw new RuntimeException("Rejected to close the service '" + this.name() + "'. The service is in status " + (Object)((Object)this.status.get()));
        }
    }

    @Override
    public final ServiceStatus getStatus() {
        return this.status.get();
    }

    @Override
    public void startServiceThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName("aviron-service-" + threadCounter.getAndIncrement());
        thread.start();
    }

    protected void enteredRunningState() {
        this.status.set(ServiceStatus.RUNNING);
    }

    protected boolean isInRunningState() {
        return this.status.get() == ServiceStatus.RUNNING;
    }

    protected boolean isInClosedState() {
        return this.status.get() == ServiceStatus.CLOSED;
    }

    protected void waitForServiceStarted(int maxSeconds) {
        long tsLimitEnd = System.currentTimeMillis() + (long)(maxSeconds * 1000);
        while (System.currentTimeMillis() < tsLimitEnd && !this.isInRunningState() && !this.isInClosedState()) {
            this.sleep(100);
        }
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

