/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.com.github.jlangch.aviron.impl.commands.scan;

import java.io.InputStream;
import org.repackage.com.github.jlangch.aviron.dto.ScanResult;
import org.repackage.com.github.jlangch.aviron.ex.UnknownCommandException;
import org.repackage.com.github.jlangch.aviron.impl.commands.CommandDef;
import org.repackage.com.github.jlangch.aviron.impl.commands.CommandFormat;
import org.repackage.com.github.jlangch.aviron.impl.commands.scan.ScanCommand;
import org.repackage.com.github.jlangch.aviron.impl.server.ClamdServerIO;

public class InStream
extends ScanCommand {
    public static final int DEFAULT_CHUNK_SIZE = 2048;
    private final InputStream inputStream;
    private final int chunkSize;

    public InStream(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public InStream(InputStream inputStream, int chunkSize) {
        this.inputStream = inputStream;
        this.chunkSize = chunkSize;
    }

    @Override
    public CommandDef getCommandDef() {
        return new CommandDef("INSTREAM", CommandFormat.NULL_CHAR);
    }

    @Override
    public ScanResult send(ClamdServerIO server) {
        String rawResponse = server.sendCommandWithDataAndReturnResponse(this.rawCommand(), this.inputStream, this.chunkSize);
        String response = this.removeResponseTerminator(rawResponse);
        if ("UNKNOWN COMMAND".equals(response)) {
            throw new UnknownCommandException(this.getCommandString());
        }
        return this.parseResponse(response);
    }
}

