/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.mbean;

import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFloat;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.VncVolatile;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public class GenericMBean
implements DynamicMBean {
    private final IDeref stateRef;

    public GenericMBean(IDeref stateRef) {
        this.stateRef = stateRef;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        VncVal state = this.stateRef.deref();
        return state instanceof VncMap ? this.getAttribute(state, attribute) : null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.setAttribute(attribute.getName(), attribute.getValue());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        VncVal state = this.stateRef.deref();
        if (state instanceof VncMap) {
            for (String attr : attributes) {
                list.add(new Attribute(attr, this.getAttribute(state, attr)));
            }
        } else {
            return null;
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        ArrayList attributeNames = new ArrayList();
        attributes.asList().forEach(a -> {
            attributeNames.add(a.getName());
            this.setAttribute(a.getName(), a.getValue());
        });
        return this.getAttributes(attributeNames.toArray(new String[0]));
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        String msg = "Dynamic MBean operations are not implemented!";
        throw new MBeanException(new RuntimeException("Dynamic MBean operations are not implemented!"), "Dynamic MBean operations are not implemented!");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attributes = this.getMBeanAttributeInfo();
        return new MBeanInfo(this.getClass().getName(), "Venice Dynamic MBean", attributes, null, null, null);
    }

    private Object getAttribute(VncVal state, String attribute) {
        return ((VncMap)state).get(new VncKeyword(attribute)).convertToJavaObject();
    }

    private void setAttribute(String name, Object value) {
        VncKeyword key = new VncKeyword(name);
        VncVal val = JavaInteropUtil.convertToVncVal(value);
        VncHashMap update = VncHashMap.of(key, val);
        if (this.stateRef instanceof VncAtom) {
            ((VncAtom)this.stateRef).swap(CoreFunctions.merge, VncList.of(update));
        } else if (this.stateRef instanceof VncVolatile) {
            ((VncVolatile)this.stateRef).swap(CoreFunctions.merge, VncList.of(update));
        }
    }

    private MBeanAttributeInfo[] getMBeanAttributeInfo() {
        ArrayList infos = new ArrayList();
        VncVal state = this.stateRef.deref();
        if (state instanceof VncMap) {
            VncMap map = (VncMap)state;
            map.keys().forEach((Consumer<? super VncVal>)((Consumer<VncVal>)k -> {
                if (k instanceof VncString) {
                    infos.add(this.getMBeanAttributeInfo(((VncString)k).getValue(), map.get((VncVal)k)));
                } else if (k instanceof VncKeyword) {
                    infos.add(this.getMBeanAttributeInfo(((VncKeyword)k).getSimpleName(), map.get((VncVal)k)));
                }
            }));
        }
        return infos.toArray(new MBeanAttributeInfo[0]);
    }

    private MBeanAttributeInfo getMBeanAttributeInfo(String name, VncVal val) {
        return new MBeanAttributeInfo(name, this.guessType(val), name, true, true, false);
    }

    private String guessType(VncVal val) {
        if (val instanceof VncInteger) {
            return "int";
        }
        if (val instanceof VncLong) {
            return "long";
        }
        if (val instanceof VncBoolean) {
            return "boolean";
        }
        if (val instanceof VncString) {
            return "java.lang.String";
        }
        if (val instanceof VncChar) {
            return "java.lang.String";
        }
        if (val instanceof VncDouble) {
            return "java.lang.Double";
        }
        if (val instanceof VncFloat) {
            return "java.lang.Float";
        }
        if (val instanceof VncBigDecimal) {
            return "java.math.BigDecimal";
        }
        if (val instanceof VncBigInteger) {
            return "java.math.BigInteger";
        }
        return val.getClass().getName();
    }
}

