/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.markdown.block;

import com.github.jlangch.venice.IPreCompiled;
import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.threadpool.GlobalThreadFactory;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.markdown.block.TableColFmt;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

public class TableColFmtParser {
    private static AtomicReference<IPreCompiled> cssParser = new AtomicReference();
    private static AtomicReference<IInterceptor> sandbox = new AtomicReference();
    private static String CSS_PARSER = "com/github/jlangch/venice/docgen/table-col-css-parser.venice";

    public TableColFmt parse(String format) {
        String fmt = StringUtil.trimToEmpty(format);
        TableColFmt fmtMD = this.parseMarkdownStyleFormat(fmt);
        if (fmtMD != null) {
            return fmtMD;
        }
        return this.parseCssStyleFormat(fmt);
    }

    private TableColFmt parseMarkdownStyleFormat(String format) {
        TableColFmt.HorzAlignment align = this.parseMarkdownStyleHorzAlignment(format);
        return align == null ? null : new TableColFmt(align, null);
    }

    private TableColFmt parseCssStyleFormat(String format) {
        String css;
        if (format.startsWith("[![") && format.endsWith("]]") && !(css = format.substring(3, format.length() - 2).trim()).isEmpty()) {
            try {
                Map<String, Object> cssProps = this.runAsync(new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        IPreCompiled precompiled = TableColFmtParser.this.getCssParser();
                        Venice venice = new Venice(TableColFmtParser.this.getParserSandbox());
                        return (Map)venice.eval(precompiled, Parameters.of("css", css));
                    }
                });
                TableColFmt.HorzAlignment align = this.parseCssStyleHorzAlignment(cssProps);
                TableColFmt.Width width = this.parseCssStyleWidth(cssProps);
                return new TableColFmt(align, width);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to parse markdown table column css '" + css + "'", ex);
            }
        }
        return null;
    }

    private TableColFmt.HorzAlignment parseCssStyleHorzAlignment(Map<String, Object> cssProps) {
        String align = (String)cssProps.get("text-align");
        switch (StringUtil.trimToEmpty(align)) {
            case "left": {
                return TableColFmt.HorzAlignment.LEFT;
            }
            case "center": {
                return TableColFmt.HorzAlignment.CENTER;
            }
            case "right": {
                return TableColFmt.HorzAlignment.RIGHT;
            }
        }
        return null;
    }

    private TableColFmt.Width parseCssStyleWidth(Map<String, Object> cssProps) {
        Object width = cssProps.get("width");
        if (width != null) {
            if (width instanceof String && "auto".equals(width)) {
                return new TableColFmt.Width(0L, TableColFmt.WidthUnit.AUTO);
            }
            if (width instanceof List) {
                long val = (Long)((List)width).get(0);
                String unit = (String)((List)width).get(1);
                switch (StringUtil.trimToEmpty(unit)) {
                    case "%": {
                        return new TableColFmt.Width(val, TableColFmt.WidthUnit.PERCENT);
                    }
                    case "px": {
                        return new TableColFmt.Width(val, TableColFmt.WidthUnit.PX);
                    }
                    case "em": {
                        return new TableColFmt.Width(val, TableColFmt.WidthUnit.EM);
                    }
                }
                return new TableColFmt.Width(0L, TableColFmt.WidthUnit.AUTO);
            }
        }
        return new TableColFmt.Width(0L, TableColFmt.WidthUnit.AUTO);
    }

    private TableColFmt.HorzAlignment parseMarkdownStyleHorzAlignment(String format) {
        if (this.isCenterAlign(format)) {
            return TableColFmt.HorzAlignment.CENTER;
        }
        if (this.isLeftAlign(format)) {
            return TableColFmt.HorzAlignment.LEFT;
        }
        if (this.isRightAlign(format)) {
            return TableColFmt.HorzAlignment.RIGHT;
        }
        return null;
    }

    private boolean isCenterAlign(String s) {
        return s.matches("---+") || s.matches("[:]-+[:]");
    }

    private boolean isLeftAlign(String s) {
        return s.matches("[:]-+");
    }

    private boolean isRightAlign(String s) {
        return s.matches("-+[:]");
    }

    private IPreCompiled getCssParser() {
        IPreCompiled pc = cssParser.get();
        if (pc == null) {
            String parser = new ClassPathResource(CSS_PARSER).getResourceAsString();
            pc = new Venice().precompile("CssParser", parser, true);
            cssParser.set(pc);
        }
        return pc;
    }

    private IInterceptor getParserSandbox() {
        IInterceptor sb = sandbox.get();
        if (sb == null) {
            sb = new SandboxInterceptor(new SandboxRules().rejectAllUnsafeFunctions().whitelistVeniceFunctions("load-module").withVeniceModules("parsifal"));
            sandbox.set(sb);
        }
        return sb;
    }

    private <T> T runAsync(Callable<T> callable) throws InterruptedException, ExecutionException {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        Thread t = GlobalThreadFactory.newThread("venice-markdown-parser", futureTask);
        t.start();
        return futureTask.get();
    }
}

