/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.sandbox;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.sandbox.RestrictedBlacklistedFunctions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SandboxFunctionGroups {
    public static Set<String> GROUPS = new HashSet<String>(Arrays.asList("*io*", "*print*", "*special-forms*", "*concurrency*", "*system*", "*java-interop*", "*unsafe*"));

    public static Set<String> groupFunctions(String group) {
        if (group.equals("*io*")) {
            return RestrictedBlacklistedFunctions.getIoFunctions();
        }
        if (group.equals("*print*")) {
            return RestrictedBlacklistedFunctions.getPrintFunctions();
        }
        if (group.equals("*special-forms*")) {
            return RestrictedBlacklistedFunctions.getSpecialForms();
        }
        if (group.equals("*concurrency*")) {
            return RestrictedBlacklistedFunctions.getConcurrencyFunctions();
        }
        if (group.equals("*system*")) {
            return RestrictedBlacklistedFunctions.getSystemFunctions();
        }
        if (group.equals("*java-interop*")) {
            return RestrictedBlacklistedFunctions.getJavaInteropFunctions();
        }
        if (group.equals("*unsafe*")) {
            return RestrictedBlacklistedFunctions.getAllFunctions();
        }
        throw new VncException(String.format("Invalid sandbox function group '%s'. Use one of %s", group, GROUPS.toString()));
    }

    public static List<String> groupFunctionsSorted(String group) {
        return SandboxFunctionGroups.groupFunctions(group).stream().sorted().collect(Collectors.toList());
    }

    public static boolean isValidGroup(String group) {
        return GROUPS.contains(group);
    }

    public static List<String> getGroups() {
        return GROUPS.stream().sorted().collect(Collectors.toList());
    }
}

